/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.pagecache;

import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.EmptyVersionContextSupplier;
import org.neo4j.kernel.impl.pagecache.ConfiguringPageCacheFactory;
import org.neo4j.kernel.impl.pagecache.PageSwapperFactoryForTesting;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.test.extension.EphemeralFileSystemExtension;
import org.neo4j.test.extension.Inject;
import org.neo4j.test.scheduler.ThreadPoolJobScheduler;

@ExtendWith(value={EphemeralFileSystemExtension.class})
class ConfiguringPageCacheFactoryTest {
    @Inject
    private FileSystemAbstraction fs;
    private JobScheduler jobScheduler;

    ConfiguringPageCacheFactoryTest() {
    }

    @BeforeEach
    void setUp() {
        this.jobScheduler = new ThreadPoolJobScheduler();
        PageSwapperFactoryForTesting.createdCounter.set(0);
        PageSwapperFactoryForTesting.configuredCounter.set(0);
    }

    @AfterEach
    void tearDown() throws Exception {
        this.jobScheduler.close();
    }

    @Test
    void shouldFitAsManyPagesAsItCan() {
        long pageCount = 60L;
        long memory = MuninnPageCache.memoryRequiredForPages((long)pageCount);
        Config config = Config.defaults((Setting)GraphDatabaseSettings.pagecache_memory, (Object)Long.toString(memory));
        ConfiguringPageCacheFactory factory = new ConfiguringPageCacheFactory(this.fs, config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)NullLog.getInstance(), EmptyVersionContextSupplier.EMPTY, this.jobScheduler);
        try (PageCache cache = factory.getOrCreatePageCache();){
            MatcherAssert.assertThat((Object)cache.pageSize(), (Matcher)CoreMatchers.equalTo((Object)8192));
            MatcherAssert.assertThat((Object)cache.maxCachedPages(), (Matcher)CoreMatchers.equalTo((Object)pageCount));
        }
    }

    @Test
    void mustUseAndLogConfiguredPageSwapper() {
        Config config = Config.newBuilder().set(GraphDatabaseSettings.pagecache_memory, (Object)"8m").set(GraphDatabaseSettings.pagecache_swapper, (Object)"pageSwapperForTesting").build();
        AssertableLogProvider logProvider = new AssertableLogProvider();
        Log log = logProvider.getLog(PageCache.class);
        ConfiguringPageCacheFactory cacheFactory = new ConfiguringPageCacheFactory(this.fs, config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, log, EmptyVersionContextSupplier.EMPTY, this.jobScheduler);
        cacheFactory.getOrCreatePageCache().close();
        MatcherAssert.assertThat((Object)PageSwapperFactoryForTesting.countCreatedPageSwapperFactories(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)PageSwapperFactoryForTesting.countConfiguredPageSwapperFactories(), (Matcher)Matchers.is((Object)1));
        logProvider.rawMessageMatcher().assertContains("pageSwapperForTesting");
    }

    @Test
    void mustThrowIfConfiguredPageSwapperCannotBeFound() {
        Config config = Config.newBuilder().set(GraphDatabaseSettings.pagecache_memory, (Object)"8m").set(GraphDatabaseSettings.pagecache_swapper, (Object)"non-existing").build();
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ConfiguringPageCacheFactory(this.fs, config, PageCacheTracer.NULL, PageCursorTracerSupplier.NULL, (Log)NullLog.getInstance(), EmptyVersionContextSupplier.EMPTY, this.jobScheduler).getOrCreatePageCache().close());
    }
}

