/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.transaction.log.LogHeaderCache;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.storageengine.api.StoreId;

class LogHeaderCacheTest {
    LogHeaderCacheTest() {
    }

    @Test
    void shouldReturnNullWhenThereIsNoHeaderInTheCache() {
        LogHeaderCache cache = new LogHeaderCache(2);
        LogHeader logHeader = cache.getLogHeader(5L);
        Assertions.assertNull((Object)logHeader);
    }

    @Test
    void shouldReturnTheHeaderIfInTheCache() {
        LogHeaderCache cache = new LogHeaderCache(2);
        cache.putHeader(5L, new LogHeader(1L, 3L, StoreId.UNKNOWN));
        LogHeader logHeader = cache.getLogHeader(5L);
        Assertions.assertEquals((long)3L, (long)logHeader.getLastCommittedTxId());
    }

    @Test
    void shouldClearTheCache() {
        LogHeaderCache cache = new LogHeaderCache(2);
        cache.putHeader(5L, new LogHeader(1L, 3L, StoreId.UNKNOWN));
        cache.clear();
        LogHeader logHeader = cache.getLogHeader(5L);
        Assertions.assertNull((Object)logHeader);
    }
}

