/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogPositionMarker;

class LogPositionMarkerTest {
    LogPositionMarkerTest() {
    }

    @Test
    void shouldReturnUnspecifiedIfNothingHasBeenMarked() {
        LogPositionMarker marker = new LogPositionMarker();
        LogPosition logPosition = marker.newPosition();
        Assertions.assertEquals((Object)LogPosition.UNSPECIFIED, (Object)logPosition);
    }

    @Test
    void shouldReturnTheMarkedPosition() {
        LogPositionMarker marker = new LogPositionMarker();
        marker.mark(1L, 2L);
        LogPosition logPosition = marker.newPosition();
        Assertions.assertEquals((Object)new LogPosition(1L, 2L), (Object)logPosition);
    }

    @Test
    void shouldReturnUnspecifiedWhenAskedTo() {
        LogPositionMarker marker = new LogPositionMarker();
        marker.mark(1L, 2L);
        marker.unspecified();
        LogPosition logPosition = marker.newPosition();
        Assertions.assertEquals((Object)LogPosition.UNSPECIFIED, (Object)logPosition);
    }
}

