/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.impl.transaction.log.LogVersionUpgradeChecker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryVersion;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.storageengine.migration.UpgradeNotAllowedException;

class LogVersionUpgradeCheckerTest {
    private LogTailScanner tailScanner = (LogTailScanner)Mockito.mock(LogTailScanner.class);

    LogVersionUpgradeCheckerTest() {
    }

    @Test
    void noThrowWhenLatestVersionAndUpgradeIsNotAllowed() {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new OnlyVersionTailInformation(LogEntryVersion.LATEST_VERSION));
        LogVersionUpgradeChecker.check((LogTailScanner)this.tailScanner, (Config)Config.defaults((Setting)GraphDatabaseSettings.allow_upgrade, (Object)false));
    }

    @Test
    void throwWhenVersionIsOlderAndUpgradeIsNotAllowed() {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new OnlyVersionTailInformation(LogEntryVersion.V3_0_10));
        Assertions.assertThrows(UpgradeNotAllowedException.class, () -> LogVersionUpgradeChecker.check((LogTailScanner)this.tailScanner, (Config)Config.defaults((Setting)GraphDatabaseSettings.allow_upgrade, (Object)false)));
    }

    @Test
    void stillAcceptLatestVersionWhenUpgradeIsAllowed() {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new OnlyVersionTailInformation(LogEntryVersion.LATEST_VERSION));
        LogVersionUpgradeChecker.check((LogTailScanner)this.tailScanner, (Config)Config.defaults((Setting)GraphDatabaseSettings.allow_upgrade, (Object)true));
    }

    @Test
    void acceptOlderLogsWhenUpgradeIsAllowed() {
        Mockito.when((Object)this.tailScanner.getTailInformation()).thenReturn((Object)new OnlyVersionTailInformation(LogEntryVersion.V3_0_10));
        LogVersionUpgradeChecker.check((LogTailScanner)this.tailScanner, (Config)Config.defaults((Setting)GraphDatabaseSettings.allow_upgrade, (Object)true));
    }

    private static class OnlyVersionTailInformation
    extends LogTailScanner.LogTailInformation {
        OnlyVersionTailInformation(LogEntryVersion logEntryVersion) {
            super(false, 0L, 0L, 0L, logEntryVersion);
        }
    }
}

