/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.pruning;

import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.neo4j.kernel.impl.transaction.log.LogFileInformation;
import org.neo4j.kernel.impl.transaction.log.pruning.EntryTimespanThreshold;
import org.neo4j.logging.AssertableLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.time.FakeClock;
import org.neo4j.time.SystemNanoClock;

class EntryTimespanThresholdTest {
    private final File file = (File)Mockito.mock(File.class);
    private final LogFileInformation source = (LogFileInformation)Mockito.mock(LogFileInformation.class);
    private final long version = 4L;
    private SystemNanoClock clock = new FakeClock(1000L, TimeUnit.MILLISECONDS);
    private final AssertableLogProvider logProvider = new AssertableLogProvider();

    EntryTimespanThresholdTest() {
    }

    @Test
    void shouldReturnFalseWhenTimeIsEqualOrAfterTheLowerLimit() throws IOException {
        EntryTimespanThreshold threshold = new EntryTimespanThreshold((LogProvider)this.logProvider, this.clock, TimeUnit.MILLISECONDS, 200L);
        Mockito.when((Object)this.source.getFirstStartRecordTimestamp(4L)).thenReturn((Object)800L);
        threshold.init();
        boolean result = threshold.reached(this.file, 4L, this.source);
        Assertions.assertFalse((boolean)result);
    }

    @Test
    void shouldReturnReturnWhenTimeIsBeforeTheLowerLimit() throws IOException {
        EntryTimespanThreshold threshold = new EntryTimespanThreshold((LogProvider)this.logProvider, this.clock, TimeUnit.MILLISECONDS, 100L);
        Mockito.when((Object)this.source.getFirstStartRecordTimestamp(4L)).thenReturn((Object)800L);
        threshold.init();
        boolean result = threshold.reached(this.file, 4L, this.source);
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void thresholdNotReachedWhenTheLogCannotBeRead() throws IOException {
        EntryTimespanThreshold threshold = new EntryTimespanThreshold((LogProvider)this.logProvider, this.clock, TimeUnit.MILLISECONDS, 100L);
        IOException ex = new IOException();
        Mockito.when((Object)this.source.getFirstStartRecordTimestamp(4L)).thenThrow(new Throwable[]{ex});
        threshold.init();
        Assertions.assertFalse((boolean)threshold.reached(this.file, 4L, this.source));
        this.logProvider.rawMessageMatcher().assertContains("Fail to get timestamp info from transaction log file");
    }
}

