/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.state;

import java.util.function.IntPredicate;
import java.util.function.Supplier;
import org.apache.commons.lang3.mutable.MutableInt;
import org.eclipse.collections.impl.block.factory.primitive.IntPredicates;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.transaction.state.storeview.PropertyAwareEntityStoreScan;
import org.neo4j.lock.LockService;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StubStorageCursors;

class PropertyAwareEntityStoreScanTest {
    private final LockService locks = (LockService)Mockito.mock(LockService.class, (Answer)Mockito.RETURNS_MOCKS);
    private final StubStorageCursors cursors = new StubStorageCursors();

    PropertyAwareEntityStoreScanTest() {
    }

    @Test
    void shouldGiveBackCompletionPercentage() {
        final long total = 10L;
        for (long i = 0L; i < total; ++i) {
            this.cursors.withNode(i);
        }
        final MutableInt read = new MutableInt();
        final PercentageSupplier percentageSupplier = new PercentageSupplier();
        PropertyAwareEntityStoreScan<StorageNodeCursor, RuntimeException> scan = new PropertyAwareEntityStoreScan<StorageNodeCursor, RuntimeException>((StorageReader)this.cursors, total, (IntPredicate)IntPredicates.alwaysTrue(), id -> this.locks.acquireNodeLock(id, LockService.LockType.READ_LOCK)){

            public boolean process(StorageNodeCursor node) {
                read.incrementAndGet();
                float expected = (float)read.intValue() / (float)total;
                float actual = percentageSupplier.get().floatValue();
                Assertions.assertEquals((double)expected, (double)actual, (double)0.0, (String)String.format("%f==%f", Float.valueOf(expected), Float.valueOf(actual)));
                return false;
            }

            protected StorageNodeCursor allocateCursor(StorageReader storageReader) {
                return storageReader.allocateNodeCursor();
            }
        };
        percentageSupplier.setStoreScan((StoreScan<?>)scan);
        scan.run();
        Assertions.assertEquals((long)total, (long)read.intValue());
    }

    private static class PercentageSupplier
    implements Supplier<Float> {
        private StoreScan<?> storeScan;

        private PercentageSupplier() {
        }

        @Override
        public Float get() {
            Assertions.assertNotNull(this.storeScan);
            PopulationProgress progress = this.storeScan.getProgress();
            return Float.valueOf((float)progress.getCompleted() / (float)progress.getTotal());
        }

        void setStoreScan(StoreScan<?> storeScan) {
            this.storeScan = storeScan;
        }
    }
}

