/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.kernel.impl.traversal.TraversalBranchImpl;

class TraversalBranchImplTest {
    TraversalBranchImplTest() {
    }

    @Test
    void shouldExpandOnFirstAccess() {
        TraversalBranch parent = (TraversalBranch)Mockito.mock(TraversalBranch.class);
        Node source = (Node)Mockito.mock(Node.class);
        TraversalBranchImpl branch = new TraversalBranchImpl(parent, source);
        PathExpander expander = (PathExpander)Mockito.mock(PathExpander.class);
        Mockito.when((Object)expander.expand((Path)ArgumentMatchers.eq((Object)branch), (BranchState)ArgumentMatchers.any(BranchState.class))).thenReturn((Object)Iterables.emptyResourceIterable());
        TraversalContext context = (TraversalContext)Mockito.mock(TraversalContext.class);
        Mockito.when((Object)context.evaluate((TraversalBranch)ArgumentMatchers.eq((Object)branch), (BranchState)ArgumentMatchers.isNull())).thenReturn((Object)Evaluation.INCLUDE_AND_CONTINUE);
        branch.initialize(expander, context);
        Mockito.verifyZeroInteractions((Object[])new Object[]{source});
        branch.next(expander, context);
        ((PathExpander)Mockito.verify((Object)expander)).expand((Path)ArgumentMatchers.any(Path.class), (BranchState)ArgumentMatchers.any(BranchState.class));
    }
}

