/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.query;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.function.LongSupplier;
import java.util.function.Supplier;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.neo4j.graphdb.ExecutionPlanDescription;
import org.neo4j.graphdb.QueryExecutionType;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.kernel.api.query.CompilerInfo;
import org.neo4j.kernel.api.query.ExecutingQueryStatus;
import org.neo4j.kernel.api.query.PageCounterValues;
import org.neo4j.kernel.api.query.QueryObfuscation;
import org.neo4j.kernel.api.query.QuerySnapshot;
import org.neo4j.kernel.api.query.SimpleState;
import org.neo4j.kernel.api.query.WaitingOnLockEvent;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.locking.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockWaitEvent;
import org.neo4j.lock.ResourceType;
import org.neo4j.memory.OptionalMemoryTracker;
import org.neo4j.resources.CpuClock;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.values.virtual.MapValue;

public class ExecutingQuery {
    private static final AtomicLongFieldUpdater<ExecutingQuery> WAIT_TIME = AtomicLongFieldUpdater.newUpdater(ExecutingQuery.class, "waitTimeNanos");
    private final long queryId;
    private final LockTracer lockTracer = this::waitForLock;
    private final String username;
    private final ClientConnectionInfo clientConnection;
    private final String rawQueryText;
    private final MapValue rawQueryParameters;
    private final long startTimeNanos;
    private final long startTimestampMillis;
    private final NamedDatabaseId namedDatabaseId;
    private final LongSupplier hitsSupplier;
    private final LongSupplier faultsSupplier;
    private long compilationCompletedNanos;
    private String obfuscatedQueryText;
    private MapValue obfuscatedQueryParameters;
    private QueryExecutionType.QueryType queryType;
    private Supplier<ExecutionPlanDescription> planDescriptionSupplier;
    private final long threadExecutingTheQueryId;
    private final String threadExecutingTheQueryName;
    private final LongSupplier activeLockCount;
    private final long initialActiveLocks;
    private final SystemNanoClock clock;
    private final CpuClock cpuClock;
    private final long cpuTimeNanosWhenQueryStarted;
    private final Map<String, Object> transactionAnnotationData;
    private CompilerInfo compilerInfo;
    private volatile ExecutingQueryStatus status = SimpleState.planning();
    private volatile long waitTimeNanos;
    private OptionalMemoryTracker memoryTracker = OptionalMemoryTracker.NONE;

    public ExecutingQuery(long queryId, ClientConnectionInfo clientConnection, NamedDatabaseId namedDatabaseId, String username, String queryText, MapValue queryParameters, Map<String, Object> transactionAnnotationData, LongSupplier activeLockCount, LongSupplier hitsSupplier, LongSupplier faultsSupplier, long threadExecutingTheQueryId, String threadExecutingTheQueryName, SystemNanoClock clock, CpuClock cpuClock) {
        this.namedDatabaseId = namedDatabaseId;
        this.hitsSupplier = hitsSupplier;
        this.faultsSupplier = faultsSupplier;
        this.cpuTimeNanosWhenQueryStarted = cpuClock.cpuTimeNanos(threadExecutingTheQueryId);
        this.startTimeNanos = clock.nanos();
        this.startTimestampMillis = clock.millis();
        this.queryId = queryId;
        this.clientConnection = clientConnection;
        this.username = username;
        this.rawQueryText = queryText;
        this.rawQueryParameters = queryParameters;
        this.transactionAnnotationData = transactionAnnotationData;
        this.activeLockCount = activeLockCount;
        this.initialActiveLocks = activeLockCount.getAsLong();
        this.threadExecutingTheQueryId = threadExecutingTheQueryId;
        this.threadExecutingTheQueryName = threadExecutingTheQueryName;
        this.cpuClock = cpuClock;
        this.clock = clock;
    }

    public void compilationCompleted(CompilerInfo compilerInfo, QueryExecutionType.QueryType queryType, Supplier<ExecutionPlanDescription> planDescriptionSupplier) {
        this.compilerInfo = compilerInfo;
        this.compilationCompletedNanos = this.clock.nanos();
        this.planDescriptionSupplier = planDescriptionSupplier;
        this.queryType = queryType;
        this.status = SimpleState.planned();
    }

    public void executionStarted(OptionalMemoryTracker memoryTracker) {
        this.memoryTracker = memoryTracker;
        this.status = SimpleState.running();
    }

    public LockTracer lockTracer() {
        return this.lockTracer;
    }

    public QuerySnapshot snapshot() {
        long currentTimeNanos;
        long cpuTimeNanos;
        ExecutingQueryStatus status;
        do {
            status = this.status;
            long waitTimeNanos = this.waitTimeNanos;
            cpuTimeNanos = this.cpuClock.cpuTimeNanos(this.threadExecutingTheQueryId);
            currentTimeNanos = this.clock.nanos();
        } while (this.status != status);
        long compilationCompletedNanos = this.compilationCompletedNanos;
        CompilerInfo planner = status.isPlanning() ? null : this.compilerInfo;
        List<ActiveLock> waitingOnLocks = status.isWaitingOnLocks() ? status.waitingOnLocks() : Collections.emptyList();
        long totalActiveLocks = this.activeLockCount.getAsLong();
        PageCounterValues pageCounters = new PageCounterValues(this.hitsSupplier, this.faultsSupplier);
        long compilationTimeNanos = (status.isPlanning() ? currentTimeNanos : compilationCompletedNanos) - this.startTimeNanos;
        long elapsedTimeNanos = currentTimeNanos - this.startTimeNanos;
        return new QuerySnapshot(this, planner, pageCounters, TimeUnit.NANOSECONDS.toMicros(compilationTimeNanos), TimeUnit.NANOSECONDS.toMicros(elapsedTimeNanos), (cpuTimeNanos -= this.cpuTimeNanosWhenQueryStarted) == 0L && this.cpuTimeNanosWhenQueryStarted == -1L ? -1L : TimeUnit.NANOSECONDS.toMicros(cpuTimeNanos), TimeUnit.NANOSECONDS.toMicros(waitTimeNanos += status.waitTimeNanos(currentTimeNanos)), status.name(), status.toMap(currentTimeNanos), waitingOnLocks, totalActiveLocks - this.initialActiveLocks, this.memoryTracker.totalAllocatedMemory());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutingQuery that = (ExecutingQuery)o;
        return this.queryId == that.queryId;
    }

    public int hashCode() {
        return (int)(this.queryId ^ this.queryId >>> 32);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public long internalQueryId() {
        return this.queryId;
    }

    public String username() {
        return this.username;
    }

    public String queryText() {
        if (this.queryNeedsObfuscation()) {
            this.obfuscateQuery();
            return this.obfuscatedQueryText;
        }
        return this.rawQueryText;
    }

    Supplier<ExecutionPlanDescription> planDescriptionSupplier() {
        return this.planDescriptionSupplier;
    }

    public MapValue queryParameters() {
        if (this.queryNeedsObfuscation()) {
            this.obfuscateQuery();
            return this.obfuscatedQueryParameters;
        }
        return this.rawQueryParameters;
    }

    public NamedDatabaseId databaseId() {
        return this.namedDatabaseId;
    }

    public long startTimestampMillis() {
        return this.startTimestampMillis;
    }

    public long elapsedNanos() {
        return this.clock.nanos() - this.startTimeNanos;
    }

    public Map<String, Object> transactionAnnotationData() {
        return this.transactionAnnotationData;
    }

    public long reportedWaitingTimeNanos() {
        return this.waitTimeNanos;
    }

    public long totalWaitingTimeNanos(long currentTimeNanos) {
        return this.waitTimeNanos + this.status.waitTimeNanos(currentTimeNanos);
    }

    ClientConnectionInfo clientConnection() {
        return this.clientConnection;
    }

    private LockWaitEvent waitForLock(boolean exclusive, ResourceType resourceType, long[] resourceIds) {
        WaitingOnLockEvent event = new WaitingOnLockEvent(exclusive ? "EXCLUSIVE" : "SHARED", resourceType, resourceIds, this, this.clock.nanos(), this.status);
        this.status = event;
        return event;
    }

    void doneWaitingOnLock(WaitingOnLockEvent waiting) {
        if (this.status != waiting) {
            return;
        }
        WAIT_TIME.addAndGet(this, waiting.waitTimeNanos(this.clock.nanos()));
        this.status = waiting.previousStatus();
    }

    private boolean queryNeedsObfuscation() {
        return this.queryType == QueryExecutionType.QueryType.DBMS || this.queryType == null || this.namedDatabaseId.equals(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID);
    }

    private void obfuscateQuery() {
        if (this.obfuscatedQueryText == null) {
            HashSet<String> passwordParams = new HashSet<String>();
            this.obfuscatedQueryText = QueryObfuscation.obfuscateText(this.rawQueryText, passwordParams);
            if (this.namedDatabaseId.equals(DatabaseIdRepository.NAMED_SYSTEM_DATABASE_ID)) {
                this.obfuscatedQueryText = QueryObfuscation.obfuscateSystemCommand(this.obfuscatedQueryText, passwordParams);
            }
            this.obfuscatedQueryParameters = QueryObfuscation.obfuscateParams(this.rawQueryParameters, passwordParams);
        }
    }
}

