/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.database;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.io.layout.DatabaseFile;
import org.neo4j.io.layout.DatabaseLayout;

class DatabaseFileHelper {
    DatabaseFileHelper() {
    }

    static List<File> filesToKeepOnTruncation(DatabaseLayout databaseLayout) {
        DatabaseFile[] filesToKeep = new DatabaseFile[]{DatabaseFile.PROPERTY_KEY_TOKEN_NAMES_STORE, DatabaseFile.PROPERTY_KEY_TOKEN_STORE, DatabaseFile.LABEL_TOKEN_NAMES_STORE, DatabaseFile.LABEL_TOKEN_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_NAMES_STORE, DatabaseFile.RELATIONSHIP_TYPE_TOKEN_STORE, DatabaseFile.SCHEMA_STORE};
        return Arrays.stream(filesToKeep).flatMap(arg_0 -> ((DatabaseLayout)databaseLayout).allFiles(arg_0)).collect(Collectors.toList());
    }

    static List<File> filesToDeleteOnTruncation(List<File> filesToKeep, DatabaseLayout databaseLayout, File[] transactionLogs) {
        ArrayList<File> filesToDelete = new ArrayList<File>();
        Collections.addAll(filesToDelete, databaseLayout.listDatabaseFiles(file -> !filesToKeep.contains(file)));
        File transactionLogsDirectory = databaseLayout.getTransactionLogsDirectory();
        if (!transactionLogsDirectory.equals(databaseLayout.databaseDirectory()) && transactionLogs != null) {
            Collections.addAll(filesToDelete, transactionLogs);
        }
        return filesToDelete;
    }
}

