/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics;

import java.io.PrintStream;
import java.util.Collections;
import org.neo4j.kernel.diagnostics.DiagnosticsReporterProgress;

public class InteractiveProgress
implements DiagnosticsReporterProgress {
    private String prefix;
    private String suffix;
    private String totalSteps = "?";
    private final PrintStream out;
    private final boolean verbose;
    private String info = "";
    private int longestInfo;

    public InteractiveProgress(PrintStream out, boolean verbose) {
        this.out = out;
        this.verbose = verbose;
    }

    @Override
    public void percentChanged(int percent) {
        this.out.print(String.format("\r%8s [", this.prefix));
        int totalWidth = 20;
        int numBars = totalWidth * percent / 100;
        for (int i = 0; i < totalWidth; ++i) {
            if (i < numBars) {
                this.out.print('#');
                continue;
            }
            this.out.print(' ');
        }
        this.out.print(String.format("] %3s%%   %s %s", percent, this.suffix, this.info));
    }

    @Override
    public void started(long currentStepIndex, String target) {
        this.prefix = currentStepIndex + "/" + this.totalSteps;
        this.suffix = target;
        this.percentChanged(0);
    }

    @Override
    public void finished() {
        this.info = String.join((CharSequence)"", Collections.nCopies(this.longestInfo, " "));
        this.percentChanged(100);
        this.out.println();
    }

    @Override
    public void info(String info) {
        this.info = info;
        if (info.length() > this.longestInfo) {
            this.longestInfo = info.length();
        }
    }

    @Override
    public void error(String msg, Throwable throwable) {
        this.out.println();
        this.out.println("Error: " + msg);
        if (this.verbose) {
            throwable.printStackTrace(this.out);
        }
    }

    @Override
    public void setTotalSteps(long steps) {
        this.totalSteps = String.valueOf(steps);
    }
}

