/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.kernel.api.exceptions.index.IndexPopulationFailedKernelException;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.impl.api.index.FailedIndexProxyFactory;
import org.neo4j.kernel.impl.api.index.FlippableIndexProxy;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.StoreScan;
import org.neo4j.kernel.impl.index.schema.BlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.UnsafeDirectByteBufferAllocator;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.memory.ThreadSafePeakMemoryAllocationTracker;
import org.neo4j.scheduler.JobHandle;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.util.concurrent.Runnables;

public class IndexPopulationJob
implements Runnable {
    private final IndexingService.Monitor monitor;
    private final boolean verifyBeforeFlipping;
    private final ByteBufferFactory bufferFactory;
    private final ThreadSafePeakMemoryAllocationTracker memoryAllocationTracker;
    private final MultipleIndexPopulator multiPopulator;
    private final CountDownLatch doneSignal = new CountDownLatch(1);
    private volatile StoreScan<IndexPopulationFailedKernelException> storeScan;
    private volatile boolean cancelled;
    private volatile JobHandle jobHandle;

    public IndexPopulationJob(MultipleIndexPopulator multiPopulator, IndexingService.Monitor monitor, boolean verifyBeforeFlipping) {
        this.multiPopulator = multiPopulator;
        this.monitor = monitor;
        this.verifyBeforeFlipping = verifyBeforeFlipping;
        this.memoryAllocationTracker = new ThreadSafePeakMemoryAllocationTracker();
        this.bufferFactory = new ByteBufferFactory(() -> new UnsafeDirectByteBufferAllocator((MemoryAllocationTracker)this.memoryAllocationTracker), BlockBasedIndexPopulator.parseBlockSize());
    }

    MultipleIndexPopulator.IndexPopulation addPopulator(IndexPopulator populator, IndexDescriptor indexDescriptor, String indexUserDescription, FlippableIndexProxy flipper, FailedIndexProxyFactory failedIndexProxyFactory) {
        assert (this.storeScan == null) : "Population have already started, too late to add populators at this point";
        return this.multiPopulator.addPopulator(populator, indexDescriptor, flipper, failedIndexProxyFactory, indexUserDescription);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        String oldThreadName;
        block9: {
            block8: {
                oldThreadName = Thread.currentThread().getName();
                try {
                    if (this.multiPopulator.hasPopulators()) break block8;
                }
                catch (Throwable throwable) {
                    Runnable[] runnableArray = new Runnable[5];
                    runnableArray[0] = () -> this.multiPopulator.close(true);
                    runnableArray[1] = () -> this.monitor.populationJobCompleted(this.memoryAllocationTracker.peakMemoryUsage());
                    runnableArray[2] = () -> ((ByteBufferFactory)this.bufferFactory).close();
                    runnableArray[3] = this.doneSignal::countDown;
                    runnableArray[4] = () -> Thread.currentThread().setName(oldThreadName);
                    Runnables.runAll((String)"Failed to close resources in IndexPopulationJob", (Runnable[])runnableArray);
                    throw throwable;
                }
                Runnable[] runnableArray = new Runnable[5];
                runnableArray[0] = () -> this.multiPopulator.close(true);
                runnableArray[1] = () -> this.monitor.populationJobCompleted(this.memoryAllocationTracker.peakMemoryUsage());
                runnableArray[2] = () -> ((ByteBufferFactory)this.bufferFactory).close();
                runnableArray[3] = this.doneSignal::countDown;
                runnableArray[4] = () -> Thread.currentThread().setName(oldThreadName);
                Runnables.runAll((String)"Failed to close resources in IndexPopulationJob", (Runnable[])runnableArray);
                return;
            }
            if (this.storeScan != null) {
                throw new IllegalStateException("Population already started.");
            }
            Thread.currentThread().setName("Index populator");
            this.multiPopulator.create();
            this.multiPopulator.resetIndexCounts();
            this.monitor.indexPopulationScanStarting();
            this.indexAllEntities();
            this.monitor.indexPopulationScanComplete();
            if (!this.cancelled) break block9;
            this.multiPopulator.cancel();
            Runnable[] runnableArray = new Runnable[5];
            runnableArray[0] = () -> this.multiPopulator.close(true);
            runnableArray[1] = () -> this.monitor.populationJobCompleted(this.memoryAllocationTracker.peakMemoryUsage());
            runnableArray[2] = () -> ((ByteBufferFactory)this.bufferFactory).close();
            runnableArray[3] = this.doneSignal::countDown;
            runnableArray[4] = () -> Thread.currentThread().setName(oldThreadName);
            Runnables.runAll((String)"Failed to close resources in IndexPopulationJob", (Runnable[])runnableArray);
            return;
        }
        try {
            this.multiPopulator.flipAfterPopulation(this.verifyBeforeFlipping);
        }
        catch (Throwable t) {
            this.multiPopulator.fail(t);
        }
        Runnable[] runnableArray = new Runnable[5];
        runnableArray[0] = () -> this.multiPopulator.close(true);
        runnableArray[1] = () -> this.monitor.populationJobCompleted(this.memoryAllocationTracker.peakMemoryUsage());
        runnableArray[2] = () -> ((ByteBufferFactory)this.bufferFactory).close();
        runnableArray[3] = this.doneSignal::countDown;
        runnableArray[4] = () -> Thread.currentThread().setName(oldThreadName);
        Runnables.runAll((String)"Failed to close resources in IndexPopulationJob", (Runnable[])runnableArray);
    }

    private void indexAllEntities() throws IndexPopulationFailedKernelException {
        this.storeScan = this.multiPopulator.indexAllEntities();
        this.storeScan.run();
    }

    PopulationProgress getPopulationProgress(MultipleIndexPopulator.IndexPopulation indexPopulation) {
        if (this.storeScan == null) {
            return PopulationProgress.NONE;
        }
        PopulationProgress storeScanProgress = this.storeScan.getProgress();
        return indexPopulation.progress(storeScanProgress);
    }

    public void cancel() {
        if (this.storeScan != null) {
            this.cancelled = true;
            this.storeScan.stop();
            this.jobHandle.cancel();
            this.monitor.populationCancelled();
        }
    }

    void cancelPopulation(MultipleIndexPopulator.IndexPopulation population) {
        this.multiPopulator.cancelIndexPopulation(population);
    }

    void dropPopulation(MultipleIndexPopulator.IndexPopulation population) {
        this.multiPopulator.dropIndexPopulation(population);
    }

    public void update(IndexEntryUpdate<?> update) {
        this.multiPopulator.queueConcurrentUpdate(update);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[populator:" + this.multiPopulator + "]";
    }

    public boolean awaitCompletion(long time, TimeUnit unit) throws InterruptedException {
        if (time == 0L) {
            this.doneSignal.await();
            return false;
        }
        boolean completed = this.doneSignal.await(time, unit);
        return !completed;
    }

    public void setHandle(JobHandle handle) {
        this.jobHandle = handle;
    }

    public ByteBufferFactory bufferFactory() {
        return this.bufferFactory;
    }
}

