/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index;

import org.neo4j.common.EntityType;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.kernel.impl.api.index.BatchingMultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.IndexStoreView;
import org.neo4j.kernel.impl.api.index.MultipleIndexPopulator;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.LogProvider;

public abstract class MultiPopulatorFactory {
    private MultiPopulatorFactory() {
    }

    public abstract MultipleIndexPopulator create(IndexStoreView var1, LogProvider var2, EntityType var3, SchemaState var4, IndexStatisticsStore var5);

    public static MultiPopulatorFactory forConfig(Config config) {
        boolean multiThreaded = (Boolean)config.get(GraphDatabaseSettings.multi_threaded_schema_index_population_enabled);
        return multiThreaded ? new MultiThreadedPopulatorFactory() : new SingleThreadedPopulatorFactory();
    }

    private static class MultiThreadedPopulatorFactory
    extends MultiPopulatorFactory {
        private MultiThreadedPopulatorFactory() {
        }

        @Override
        public MultipleIndexPopulator create(IndexStoreView storeView, LogProvider logProvider, EntityType type, SchemaState schemaState, IndexStatisticsStore indexStatisticsStore) {
            return new BatchingMultipleIndexPopulator(storeView, logProvider, type, schemaState, indexStatisticsStore);
        }
    }

    private static class SingleThreadedPopulatorFactory
    extends MultiPopulatorFactory {
        private SingleThreadedPopulatorFactory() {
        }

        @Override
        public MultipleIndexPopulator create(IndexStoreView storeView, LogProvider logProvider, EntityType type, SchemaState schemaState, IndexStatisticsStore indexStatisticsStore) {
            return new MultipleIndexPopulator(storeView, logProvider, type, schemaState, indexStatisticsStore);
        }
    }
}

