/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.index.sampling;

import java.util.function.LongPredicate;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexMapSnapshotProvider;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingController;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingJobTracker;
import org.neo4j.kernel.impl.api.index.sampling.OnlineIndexSamplingJobFactory;
import org.neo4j.kernel.impl.api.index.sampling.RecoveryCondition;
import org.neo4j.kernel.impl.api.index.stats.IndexStatisticsStore;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.register.Register;
import org.neo4j.register.Registers;
import org.neo4j.scheduler.JobScheduler;

public class IndexSamplingControllerFactory {
    private final IndexSamplingConfig config;
    private final IndexStatisticsStore indexStatisticsStore;
    private final JobScheduler scheduler;
    private final TokenNameLookup tokenNameLookup;
    private final LogProvider logProvider;

    public IndexSamplingControllerFactory(IndexSamplingConfig config, IndexStatisticsStore indexStatisticsStore, JobScheduler scheduler, TokenNameLookup tokenNameLookup, LogProvider logProvider) {
        this.config = config;
        this.indexStatisticsStore = indexStatisticsStore;
        this.scheduler = scheduler;
        this.tokenNameLookup = tokenNameLookup;
        this.logProvider = logProvider;
    }

    public IndexSamplingController create(IndexMapSnapshotProvider snapshotProvider) {
        OnlineIndexSamplingJobFactory jobFactory = new OnlineIndexSamplingJobFactory(this.indexStatisticsStore, this.tokenNameLookup, this.logProvider);
        LongPredicate samplingUpdatePredicate = this.createSamplingPredicate();
        IndexSamplingJobTracker jobTracker = new IndexSamplingJobTracker(this.config, this.scheduler);
        RecoveryCondition indexRecoveryCondition = this.createIndexRecoveryCondition(this.logProvider, this.tokenNameLookup);
        return new IndexSamplingController(this.config, jobFactory, samplingUpdatePredicate, jobTracker, snapshotProvider, this.scheduler, indexRecoveryCondition, this.logProvider);
    }

    private LongPredicate createSamplingPredicate() {
        return indexId -> {
            Register.DoubleLongRegister output = Registers.newDoubleLongRegister();
            this.indexStatisticsStore.indexUpdatesAndSize(indexId, output);
            long updates = output.readFirst();
            long size = output.readSecond();
            long threshold = Math.round(this.config.updateRatio() * (double)size);
            return updates > threshold;
        };
    }

    private RecoveryCondition createIndexRecoveryCondition(final LogProvider logProvider, final TokenNameLookup tokenNameLookup) {
        return new RecoveryCondition(){
            private final Log log;
            private final Register.DoubleLongRegister register;
            {
                this.log = logProvider.getLog(IndexSamplingController.class);
                this.register = Registers.newDoubleLongRegister();
            }

            @Override
            public boolean test(IndexDescriptor descriptor) {
                boolean result;
                long samples = IndexSamplingControllerFactory.this.indexStatisticsStore.indexSample(descriptor.getId(), this.register).readSecond();
                long size = IndexSamplingControllerFactory.this.indexStatisticsStore.indexUpdatesAndSize(descriptor.getId(), this.register).readSecond();
                boolean bl = result = samples == 0L || size == 0L;
                if (result) {
                    this.log.debug("Recovering index sampling for index %s", new Object[]{descriptor.schema().userDescription(tokenNameLookup)});
                }
                return result;
            }
        };
    }
}

