/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.api.security;

import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.kernel.impl.api.security.WrappedAccessMode;

public class RestrictedAccessMode
extends WrappedAccessMode {
    public RestrictedAccessMode(AccessMode original, AccessMode restricting) {
        super(original, restricting);
    }

    public boolean allowsWrites() {
        return this.original.allowsWrites() && this.wrapping.allowsWrites();
    }

    public boolean allowsTokenCreates(PrivilegeAction action) {
        return this.original.allowsTokenCreates(action) && this.wrapping.allowsTokenCreates(action);
    }

    public boolean allowsSchemaWrites() {
        return this.original.allowsSchemaWrites() && this.wrapping.allowsSchemaWrites();
    }

    public boolean allowsSchemaWrites(PrivilegeAction action) {
        return this.original.allowsSchemaWrites(action) && this.wrapping.allowsSchemaWrites(action);
    }

    public boolean allowsTraverseAllLabels() {
        return this.original.allowsTraverseAllLabels() && this.wrapping.allowsTraverseAllLabels();
    }

    public boolean allowsTraverseAllNodesWithLabel(long label) {
        return this.original.allowsTraverseAllNodesWithLabel(label) && this.wrapping.allowsTraverseAllNodesWithLabel(label);
    }

    public boolean allowsSeeLabelToken(long label) {
        return this.original.allowsSeeLabelToken(label) && this.wrapping.allowsSeeLabelToken(label);
    }

    public boolean disallowsTraverseLabel(long label) {
        return this.original.disallowsTraverseLabel(label) || this.wrapping.disallowsTraverseLabel(label);
    }

    public boolean allowsTraverseNode(long ... labels) {
        return this.original.allowsTraverseNode(labels) && this.wrapping.allowsTraverseNode(labels);
    }

    public boolean allowsTraverseAllRelTypes() {
        return this.original.allowsTraverseAllRelTypes() && this.wrapping.allowsTraverseAllRelTypes();
    }

    public boolean allowsTraverseRelType(int relType) {
        return this.original.allowsTraverseRelType(relType) && this.wrapping.allowsTraverseRelType(relType);
    }

    public boolean allowsReadPropertyAllLabels(int propertyKey) {
        return this.original.allowsReadPropertyAllLabels(propertyKey) && this.wrapping.allowsReadPropertyAllLabels(propertyKey);
    }

    public boolean disallowsReadPropertyForSomeLabel(int propertyKey) {
        return this.original.disallowsReadPropertyForSomeLabel(propertyKey) && this.wrapping.disallowsReadPropertyForSomeLabel(propertyKey);
    }

    public boolean allowsReadNodeProperty(Supplier<LabelSet> labels, int propertyKey) {
        return this.original.allowsReadNodeProperty(labels, propertyKey) && this.wrapping.allowsReadNodeProperty(labels, propertyKey);
    }

    public boolean allowsReadPropertyAllRelTypes(int propertyKey) {
        return this.original.allowsReadPropertyAllRelTypes(propertyKey) && this.wrapping.allowsReadPropertyAllRelTypes(propertyKey);
    }

    public boolean allowsReadRelationshipProperty(IntSupplier relType, int propertyKey) {
        return this.original.allowsReadRelationshipProperty(relType, propertyKey) && this.wrapping.allowsReadRelationshipProperty(relType, propertyKey);
    }

    public boolean allowsSeePropertyKeyToken(int propertyKey) {
        return this.original.allowsSeePropertyKeyToken(propertyKey) && this.wrapping.allowsSeePropertyKeyToken(propertyKey);
    }

    public boolean allowsProcedureWith(String[] allowed) {
        return false;
    }

    public String name() {
        return this.original.name() + " restricted to " + this.wrapping.name();
    }
}

