/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.index.internal.gbptree.Writer;
import org.neo4j.internal.helpers.Exceptions;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.PopulationProgress;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.api.index.PhaseTracker;
import org.neo4j.kernel.impl.index.schema.BlockEntryReader;
import org.neo4j.kernel.impl.index.schema.BlockReader;
import org.neo4j.kernel.impl.index.schema.BlockStorage;
import org.neo4j.kernel.impl.index.schema.ConflictDetectingValueMerger;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.IndexKeyStorage;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.IndexUpdateCursor;
import org.neo4j.kernel.impl.index.schema.IndexUpdateStorage;
import org.neo4j.kernel.impl.index.schema.MergingBlockEntryReader;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.NativeIndexUpdater;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.util.FeatureToggles;
import org.neo4j.util.Preconditions;
import org.neo4j.util.concurrent.Runnables;
import org.neo4j.values.storable.Value;

public abstract class BlockBasedIndexPopulator<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NativeIndexPopulator<KEY, VALUE> {
    public static final String BLOCK_SIZE_NAME = "blockSize";
    private final boolean archiveFailedIndex;
    private final int mergeFactor;
    private final BlockStorage.Monitor blockStorageMonitor;
    private final List<ThreadLocalBlockStorage> allScanUpdates = new CopyOnWriteArrayList<ThreadLocalBlockStorage>();
    private final ThreadLocal<ThreadLocalBlockStorage> scanUpdates;
    private final ByteBufferFactory bufferFactory;
    private IndexUpdateStorage<KEY, VALUE> externalUpdates;
    private volatile boolean scanCompleted;
    private final CloseCancellation cancellation = new CloseCancellation();
    private volatile CountDownLatch mergeOngoingLatch;
    private volatile long numberOfAppliedScanUpdates;
    private volatile long numberOfAppliedExternalUpdates;

    BlockBasedIndexPopulator(PageCache pageCache, FileSystemAbstraction fs, IndexFiles indexFiles, IndexLayout<KEY, VALUE> layout, IndexProvider.Monitor monitor, IndexDescriptor descriptor, boolean archiveFailedIndex, ByteBufferFactory bufferFactory) {
        this(pageCache, fs, indexFiles, layout, monitor, descriptor, archiveFailedIndex, bufferFactory, FeatureToggles.getInteger(BlockBasedIndexPopulator.class, (String)"mergeFactor", (int)8), BlockStorage.Monitor.NO_MONITOR);
    }

    BlockBasedIndexPopulator(PageCache pageCache, FileSystemAbstraction fs, IndexFiles indexFiles, IndexLayout<KEY, VALUE> layout, IndexProvider.Monitor monitor, IndexDescriptor descriptor, boolean archiveFailedIndex, ByteBufferFactory bufferFactory, int mergeFactor, BlockStorage.Monitor blockStorageMonitor) {
        super(pageCache, fs, indexFiles, layout, monitor, descriptor, GBPTree.NO_HEADER_WRITER);
        this.archiveFailedIndex = archiveFailedIndex;
        this.mergeFactor = mergeFactor;
        this.blockStorageMonitor = blockStorageMonitor;
        this.scanUpdates = ThreadLocal.withInitial(this::newThreadLocalBlockStorage);
        this.bufferFactory = bufferFactory;
    }

    private synchronized ThreadLocalBlockStorage newThreadLocalBlockStorage() {
        Preconditions.checkState((!this.cancellation.cancelled() ? 1 : 0) != 0, (String)"Already closed");
        Preconditions.checkState((!this.scanCompleted ? 1 : 0) != 0, (String)"Scan has already been completed");
        try {
            int id = this.allScanUpdates.size();
            ThreadLocalBlockStorage blockStorage = new ThreadLocalBlockStorage(id);
            this.allScanUpdates.add(blockStorage);
            return blockStorage;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static int parseBlockSize() {
        long blockSize = ByteUnit.parse((String)FeatureToggles.getString(BlockBasedIndexPopulator.class, (String)BLOCK_SIZE_NAME, (String)"1M"));
        Preconditions.checkArgument((blockSize >= 20L && blockSize < Integer.MAX_VALUE ? 1 : 0) != 0, (String)("Block size need to fit in int. Was " + blockSize));
        return (int)blockSize;
    }

    @Override
    public void create() {
        if (this.archiveFailedIndex) {
            this.indexFiles.archiveIndex();
        }
        super.create();
        try {
            File storeFile = this.indexFiles.getStoreFile();
            File externalUpdatesFile = new File(storeFile.getParent(), storeFile.getName() + ".ext");
            this.externalUpdates = new IndexUpdateStorage(this.fileSystem, externalUpdatesFile, this.bufferFactory.globalAllocator(), this.smallerBufferSize(), this.layout);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private int smallerBufferSize() {
        return this.bufferFactory.bufferSize() / 2;
    }

    @Override
    public void add(Collection<? extends IndexEntryUpdate<?>> updates) {
        if (!updates.isEmpty()) {
            BlockStorage blockStorage = this.scanUpdates.get().blockStorage;
            for (IndexEntryUpdate<?> update : updates) {
                this.storeUpdate(update, blockStorage);
            }
        }
    }

    private void storeUpdate(long entityId, Value[] values, BlockStorage<KEY, VALUE> blockStorage) {
        try {
            NativeIndexKey key = (NativeIndexKey)((Object)this.layout.newKey());
            Object value = this.layout.newValue();
            NativeIndexUpdater.initializeKeyFromUpdate(key, entityId, values);
            ((NativeIndexValue)value).from(values);
            blockStorage.add(key, value);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void storeUpdate(IndexEntryUpdate<?> update, BlockStorage<KEY, VALUE> blockStorage) {
        this.storeUpdate(update.getEntityId(), update.values(), blockStorage);
    }

    private synchronized boolean markMergeStarted() {
        this.scanCompleted = true;
        if (this.cancellation.cancelled()) {
            return false;
        }
        this.mergeOngoingLatch = new CountDownLatch(1);
        return true;
    }

    public void scanCompleted(PhaseTracker phaseTracker) throws IndexEntryConflictException {
        block28: {
            if (!this.markMergeStarted()) {
                return;
            }
            try {
                phaseTracker.enterPhase(PhaseTracker.Phase.MERGE);
                if (!this.allScanUpdates.isEmpty()) {
                    this.mergeScanUpdates();
                }
                this.externalUpdates.doneAdding();
                if (this.cancellation.cancelled()) {
                    return;
                }
                phaseTracker.enterPhase(PhaseTracker.Phase.BUILD);
                File storeFile = this.indexFiles.getStoreFile();
                File duplicatesFile = new File(storeFile.getParentFile(), storeFile.getName() + ".dup");
                int readBufferSize = this.smallerBufferSize();
                try (ByteBufferFactory.Allocator allocator = this.bufferFactory.newLocalAllocator();
                     IndexKeyStorage indexKeyStorage = new IndexKeyStorage(this.fileSystem, duplicatesFile, allocator, readBufferSize, this.layout);){
                    RecordingConflictDetector recordingConflictDetector = new RecordingConflictDetector(!this.descriptor.isUnique(), indexKeyStorage);
                    this.writeScanUpdatesToTree(recordingConflictDetector, allocator, readBufferSize);
                    phaseTracker.enterPhase(PhaseTracker.Phase.APPLY_EXTERNAL);
                    this.writeExternalUpdatesToTree(recordingConflictDetector);
                    if (!this.descriptor.isUnique()) break block28;
                    try (IndexKeyStorage.KeyEntryCursor allConflictingKeys = recordingConflictDetector.allConflicts();){
                        this.verifyUniqueKeys(allConflictingKeys);
                    }
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException("Got interrupted, so merge not completed", e);
            }
            catch (ExecutionException e) {
                Throwable executionException = e.getCause();
                Exceptions.throwIfUnchecked((Throwable)executionException);
                throw new RuntimeException(executionException);
            }
            finally {
                this.mergeOngoingLatch.countDown();
            }
        }
    }

    private void mergeScanUpdates() throws InterruptedException, ExecutionException, IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(this.allScanUpdates.size());
        ArrayList<Future<Object>> mergeFutures = new ArrayList<Future<Object>>();
        for (ThreadLocalBlockStorage threadLocalBlockStorage : this.allScanUpdates) {
            BlockStorage scanUpdates = threadLocalBlockStorage.blockStorage;
            scanUpdates.doneAdding();
            mergeFutures.add(executorService.submit(() -> {
                scanUpdates.merge(this.mergeFactor, this.cancellation);
                return null;
            }));
        }
        executorService.shutdown();
        while (!executorService.awaitTermination(1L, TimeUnit.SECONDS)) {
        }
        for (Future future : mergeFutures) {
            future.get();
        }
    }

    private void writeExternalUpdatesToTree(RecordingConflictDetector<KEY, VALUE> recordingConflictDetector) throws IOException, IndexEntryConflictException {
        try (Writer writer = this.tree.writer();
             IndexUpdateCursor updates = (IndexUpdateCursor)this.externalUpdates.reader();){
            while (updates.next() && !this.cancellation.cancelled()) {
                switch (updates.updateMode()) {
                    case ADDED: {
                        this.writeToTree(writer, recordingConflictDetector, (NativeIndexKey)((Object)updates.key()), (NativeIndexValue)updates.value());
                        break;
                    }
                    case REMOVED: {
                        writer.remove((Object)((NativeIndexKey)((Object)updates.key())));
                        break;
                    }
                    case CHANGED: {
                        writer.remove((Object)((NativeIndexKey)((Object)updates.key())));
                        this.writeToTree(writer, recordingConflictDetector, (NativeIndexKey)((Object)updates.key2()), (NativeIndexValue)updates.value());
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown update mode " + updates.updateMode());
                    }
                }
                ++this.numberOfAppliedExternalUpdates;
            }
        }
    }

    private void verifyUniqueKeys(IndexKeyStorage.KeyEntryCursor<KEY> allConflictingKeys) throws IOException, IndexEntryConflictException {
        while (allConflictingKeys.next() && !this.cancellation.cancelled()) {
            NativeIndexKey key = (NativeIndexKey)((Object)allConflictingKeys.key());
            key.setCompareId(false);
            this.verifyUniqueSeek(this.tree.seek((Object)key, (Object)key));
        }
    }

    private void verifyUniqueSeek(Seeker<KEY, VALUE> seek) throws IOException, IndexEntryConflictException {
        if (seek != null && seek.next()) {
            NativeIndexKey key = (NativeIndexKey)((Object)seek.key());
            long firstEntityId = key.getEntityId();
            if (seek.next()) {
                long secondEntityId = key.getEntityId();
                throw new IndexEntryConflictException(firstEntityId, secondEntityId, key.asValues());
            }
        }
    }

    private void writeScanUpdatesToTree(RecordingConflictDetector<KEY, VALUE> recordingConflictDetector, ByteBufferFactory.Allocator allocator, int bufferSize) throws IOException, IndexEntryConflictException {
        try (MergingBlockEntryReader allEntries = new MergingBlockEntryReader(this.layout);){
            ByteBuffer singleBlockAssertionBuffer = allocator.allocate((int)ByteUnit.kibiBytes((long)8L));
            for (ThreadLocalBlockStorage part : this.allScanUpdates) {
                BlockReader reader = part.blockStorage.reader();
                try {
                    BlockEntryReader singleMergedBlock = reader.nextBlock(allocator.allocate(bufferSize));
                    if (singleMergedBlock == null) continue;
                    allEntries.addSource(singleMergedBlock);
                    if (reader.nextBlock(singleBlockAssertionBuffer) == null) continue;
                    throw new IllegalStateException("Final BlockStorage had multiple blocks");
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            boolean asMuchAsPossibleToTheLeft = true;
            try (Writer writer = this.tree.writer((double)asMuchAsPossibleToTheLeft);){
                while (allEntries.next() && !this.cancellation.cancelled()) {
                    this.writeToTree(writer, recordingConflictDetector, (NativeIndexKey)((Object)allEntries.key()), (NativeIndexValue)allEntries.value());
                    ++this.numberOfAppliedScanUpdates;
                }
            }
        }
    }

    @Override
    public IndexUpdater newPopulatingUpdater() {
        if (this.scanCompleted) {
            return super.newPopulatingUpdater();
        }
        return new IndexUpdater(){
            private volatile boolean closed;

            public void process(IndexEntryUpdate<?> update) {
                this.assertOpen();
                try {
                    BlockBasedIndexPopulator.this.externalUpdates.add(update);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }

            public void close() {
                this.closed = true;
            }

            private void assertOpen() {
                if (this.closed) {
                    throw new IllegalStateException("Updater has been closed");
                }
            }
        };
    }

    @Override
    public synchronized void drop() {
        Runnables.runAll((String)"Failed while trying to drop index", (Runnable[])new Runnable[]{this::closeBlockStorage, () -> super.drop()});
    }

    @Override
    public synchronized void close(boolean populationCompletedSuccessfully) {
        Runnables.runAll((String)"Failed while trying to close index", (Runnable[])new Runnable[]{this::closeBlockStorage, () -> super.close(populationCompletedSuccessfully)});
    }

    private void closeBlockStorage() {
        this.cancellation.setCancel();
        if (this.mergeOngoingLatch != null) {
            try {
                this.mergeOngoingLatch.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        List toClose = this.allScanUpdates.stream().map(local -> local.blockStorage).collect(Collectors.toCollection(ArrayList::new));
        toClose.add(this.externalUpdates);
        IOUtils.closeAllUnchecked((Collection)toClose);
    }

    public PopulationProgress progress(PopulationProgress scanProgress) {
        PopulationProgress treeBuildProgress;
        PopulationProgress.MultiBuilder builder = PopulationProgress.multiple();
        builder.add(scanProgress, 4.0f);
        if (!this.allScanUpdates.isEmpty()) {
            long completed = 0L;
            long total = 0L;
            if (this.scanCompleted) {
                ThreadLocalBlockStorage part2 = (ThreadLocalBlockStorage)Iterables.first(this.allScanUpdates);
                completed = part2.entriesMerged;
                total = part2.totalEntriesToMerge;
            }
            builder.add(PopulationProgress.single((long)completed, (long)total), 1.0f);
        }
        if (this.allScanUpdates.stream().allMatch(part -> part.mergeStarted)) {
            long entryCount = this.allScanUpdates.stream().mapToLong(part -> part.count).sum() + this.externalUpdates.count();
            treeBuildProgress = PopulationProgress.single((long)(this.numberOfAppliedScanUpdates + this.numberOfAppliedExternalUpdates), (long)entryCount);
        } else {
            treeBuildProgress = PopulationProgress.NONE;
        }
        builder.add(treeBuildProgress, 2.0f);
        return builder.build();
    }

    private void writeToTree(Writer<KEY, VALUE> writer, RecordingConflictDetector<KEY, VALUE> recordingConflictDetector, KEY key, VALUE value) throws IndexEntryConflictException {
        recordingConflictDetector.controlConflictDetection(key);
        writer.merge(key, value, recordingConflictDetector);
        this.handleMergeConflict(writer, recordingConflictDetector, key, value);
    }

    private void handleMergeConflict(Writer<KEY, VALUE> writer, RecordingConflictDetector<KEY, VALUE> recordingConflictDetector, KEY key, VALUE value) throws IndexEntryConflictException {
        if (recordingConflictDetector.wasConflicting()) {
            NativeIndexKey copy = (NativeIndexKey)((Object)this.layout.newKey());
            this.layout.copyKey(key, (Object)copy);
            recordingConflictDetector.reportConflict(copy);
            recordingConflictDetector.relaxUniqueness(key);
            writer.put(key, value);
        }
    }

    private static class RecordingConflictDetector<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
    extends ConflictDetectingValueMerger<KEY, VALUE, KEY> {
        private final IndexKeyStorage<KEY> allConflictingKeys;

        RecordingConflictDetector(boolean compareEntityIds, IndexKeyStorage<KEY> indexKeyStorage) {
            super(compareEntityIds);
            this.allConflictingKeys = indexKeyStorage;
        }

        @Override
        void doReportConflict(long existingNodeId, long addedNodeId, KEY conflictingKey) {
            try {
                this.allConflictingKeys.add(conflictingKey);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        IndexKeyStorage.KeyEntryCursor<KEY> allConflicts() throws IOException {
            this.allConflictingKeys.doneAdding();
            return (IndexKeyStorage.KeyEntryCursor)this.allConflictingKeys.reader();
        }

        void relaxUniqueness(KEY key) {
            ((NativeIndexKey)((Object)key)).setCompareId(true);
        }
    }

    private static class CloseCancellation
    implements BlockStorage.Cancellation {
        private volatile boolean cancelled;

        private CloseCancellation() {
        }

        void setCancel() {
            this.cancelled = true;
        }

        @Override
        public boolean cancelled() {
            return this.cancelled;
        }
    }

    private class ThreadLocalBlockStorage
    extends BlockStorage.Monitor.Delegate {
        private final BlockStorage<KEY, VALUE> blockStorage;
        private volatile long count;
        private volatile boolean mergeStarted;
        private volatile long totalEntriesToMerge;
        private volatile long entriesMerged;

        ThreadLocalBlockStorage(int id) throws IOException {
            super(BlockBasedIndexPopulator.this.blockStorageMonitor);
            File storeFile = BlockBasedIndexPopulator.this.indexFiles.getStoreFile();
            File blockFile = new File(storeFile.getParentFile(), storeFile.getName() + ".scan-" + id);
            this.blockStorage = new BlockStorage(BlockBasedIndexPopulator.this.layout, BlockBasedIndexPopulator.this.bufferFactory, BlockBasedIndexPopulator.this.fileSystem, blockFile, this);
        }

        @Override
        public void mergeStarted(long entryCount, long totalEntriesToWriteDuringMerge) {
            super.mergeStarted(entryCount, totalEntriesToWriteDuringMerge);
            this.count = entryCount;
            this.totalEntriesToMerge = totalEntriesToWriteDuringMerge;
            this.mergeStarted = true;
        }

        @Override
        public void entriesMerged(int entries) {
            super.entriesMerged(entries);
            this.entriesMerged += (long)entries;
        }
    }
}

