/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.QueryContext;
import org.neo4j.internal.kernel.api.exceptions.schema.IndexNotApplicableKernelException;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.impl.index.schema.NodeValueIterator;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.UpdateMode;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;

public class DeferredConflictCheckingIndexUpdater
implements IndexUpdater {
    private final IndexUpdater actual;
    private final Supplier<IndexReader> readerSupplier;
    private final IndexDescriptor indexDescriptor;
    private final Set<ValueTuple> touchedTuples = new HashSet<ValueTuple>();

    public DeferredConflictCheckingIndexUpdater(IndexUpdater actual, Supplier<IndexReader> readerSupplier, IndexDescriptor indexDescriptor) {
        this.actual = actual;
        this.readerSupplier = readerSupplier;
        this.indexDescriptor = indexDescriptor;
    }

    public void process(IndexEntryUpdate<?> update) throws IndexEntryConflictException {
        this.actual.process(update);
        if (update.updateMode() != UpdateMode.REMOVED) {
            this.touchedTuples.add(ValueTuple.of((Value[])update.values()));
        }
    }

    public void close() throws IndexEntryConflictException {
        this.actual.close();
        try (IndexReader reader = this.readerSupplier.get();){
            for (ValueTuple tuple : this.touchedTuples) {
                try (NodeValueIterator client = new NodeValueIterator();){
                    reader.query(QueryContext.NULL_CONTEXT, (IndexProgressor.EntityValueClient)client, IndexOrder.NONE, false, this.queryOf(tuple));
                    if (!client.hasNext()) continue;
                    long firstEntityId = client.next();
                    if (!client.hasNext()) continue;
                    long secondEntityId = client.next();
                    throw new IndexEntryConflictException(firstEntityId, secondEntityId, tuple);
                }
            }
        }
        catch (IndexNotApplicableKernelException e) {
            throw new IllegalArgumentException("Unexpectedly the index reader couldn't handle this query", e);
        }
    }

    private IndexQuery[] queryOf(ValueTuple tuple) {
        IndexQuery[] predicates = new IndexQuery[tuple.size()];
        int[] propertyIds = this.indexDescriptor.schema().getPropertyIds();
        for (int i = 0; i < predicates.length; ++i) {
            predicates[i] = IndexQuery.exact((int)propertyIds[i], (Object)tuple.valueAt(i));
        }
        return predicates;
    }
}

