/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.File;
import java.util.Map;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.gis.spatial.index.curves.SpaceFillingCurveConfiguration;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.schema.IndexCapability;
import org.neo4j.internal.schema.IndexConfig;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexLimitation;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexValueCapability;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.memory.ByteBufferFactory;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;
import org.neo4j.kernel.api.index.IndexPopulator;
import org.neo4j.kernel.api.index.IndexProvider;
import org.neo4j.kernel.impl.index.schema.GenericBlockBasedIndexPopulator;
import org.neo4j.kernel.impl.index.schema.GenericKey;
import org.neo4j.kernel.impl.index.schema.GenericLayout;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexAccessor;
import org.neo4j.kernel.impl.index.schema.GenericNativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.IndexFiles;
import org.neo4j.kernel.impl.index.schema.NativeIndexProvider;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;
import org.neo4j.kernel.impl.index.schema.SpatialIndexConfig;
import org.neo4j.kernel.impl.index.schema.WorkSyncedNativeIndexPopulator;
import org.neo4j.kernel.impl.index.schema.config.ConfiguredSpaceFillingCurveSettingsCache;
import org.neo4j.kernel.impl.index.schema.config.IndexSpecificSpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettings;
import org.neo4j.kernel.impl.index.schema.config.SpaceFillingCurveSettingsFactory;
import org.neo4j.util.FeatureToggles;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.ValueCategory;

public class GenericNativeIndexProvider
extends NativeIndexProvider<GenericKey, NativeIndexValue, GenericLayout> {
    public static final String KEY = GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerKey();
    public static final IndexProviderDescriptor DESCRIPTOR = new IndexProviderDescriptor(KEY, GraphDatabaseSettings.SchemaIndex.NATIVE_BTREE10.providerVersion());
    public static final IndexCapability CAPABILITY = new GenericIndexCapability();
    public static final String BLOCK_BASED_POPULATION_NAME = "blockBasedPopulation";
    private final boolean blockBasedPopulation = FeatureToggles.flag(GenericNativeIndexPopulator.class, (String)"blockBasedPopulation", (boolean)true);
    private final ConfiguredSpaceFillingCurveSettingsCache configuredSettings;
    private final SpaceFillingCurveConfiguration configuration;
    private final boolean archiveFailedIndex;

    public GenericNativeIndexProvider(IndexDirectoryStructure.Factory directoryStructureFactory, PageCache pageCache, FileSystemAbstraction fs, IndexProvider.Monitor monitor, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, boolean readOnly, Config config) {
        super(DESCRIPTOR, directoryStructureFactory, pageCache, fs, monitor, recoveryCleanupWorkCollector, readOnly);
        this.configuredSettings = new ConfiguredSpaceFillingCurveSettingsCache(config);
        this.configuration = SpaceFillingCurveSettingsFactory.getConfiguredSpaceFillingCurveConfiguration(config);
        this.archiveFailedIndex = (Boolean)config.get(GraphDatabaseSettings.archive_failed_index);
    }

    public IndexDescriptor completeConfiguration(IndexDescriptor index) {
        IndexConfig indexConfig = index.getIndexConfig();
        if ((index = index.withIndexConfig(indexConfig = this.completeSpatialConfiguration(indexConfig))).getCapability().equals(IndexCapability.NO_CAPABILITY)) {
            index = index.withIndexCapability(CAPABILITY);
        }
        return index;
    }

    private IndexConfig completeSpatialConfiguration(IndexConfig indexConfig) {
        for (CoordinateReferenceSystem crs : CoordinateReferenceSystem.all()) {
            SpaceFillingCurveSettings spaceFillingCurveSettings = this.configuredSettings.forCRS(crs);
            indexConfig = SpatialIndexConfig.addSpatialConfig(indexConfig, crs, spaceFillingCurveSettings);
        }
        return indexConfig;
    }

    @Override
    GenericLayout layout(IndexDescriptor descriptor, File storeFile) {
        int numberOfSlots = descriptor.schema().getPropertyIds().length;
        IndexConfig indexConfig = descriptor.getIndexConfig();
        Map<CoordinateReferenceSystem, SpaceFillingCurveSettings> settings = SpatialIndexConfig.extractSpatialConfig(indexConfig);
        return new GenericLayout(numberOfSlots, new IndexSpecificSpaceFillingCurveSettings(settings));
    }

    @Override
    protected IndexPopulator newIndexPopulator(IndexFiles indexFiles, GenericLayout layout, IndexDescriptor descriptor, ByteBufferFactory bufferFactory) {
        if (this.blockBasedPopulation) {
            return new GenericBlockBasedIndexPopulator(this.pageCache, this.fs, indexFiles, layout, this.monitor, descriptor, layout.getSpaceFillingCurveSettings(), this.configuration, this.archiveFailedIndex, bufferFactory);
        }
        return new WorkSyncedNativeIndexPopulator<GenericKey, NativeIndexValue>(new GenericNativeIndexPopulator(this.pageCache, this.fs, indexFiles, layout, this.monitor, descriptor, layout.getSpaceFillingCurveSettings(), this.configuration, this.archiveFailedIndex));
    }

    @Override
    protected IndexAccessor newIndexAccessor(IndexFiles indexFiles, GenericLayout layout, IndexDescriptor descriptor, boolean readOnly) {
        return new GenericNativeIndexAccessor(this.pageCache, this.fs, indexFiles, layout, this.recoveryCleanupWorkCollector, this.monitor, descriptor, layout.getSpaceFillingCurveSettings(), this.configuration, readOnly);
    }

    public void validatePrototype(IndexPrototype prototype) {
        super.validatePrototype(prototype);
        IndexConfig indexConfig = prototype.getIndexConfig();
        indexConfig = this.completeSpatialConfiguration(indexConfig);
        try {
            SpatialIndexConfig.validateSpatialConfig(indexConfig);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid spatial index settings.", e);
        }
    }

    private static class GenericIndexCapability
    implements IndexCapability {
        private final IndexLimitation[] limitations = new IndexLimitation[]{IndexLimitation.SLOW_CONTAINS};

        private GenericIndexCapability() {
        }

        public IndexOrder[] orderCapability(ValueCategory ... valueCategories) {
            if (this.supportOrdering(valueCategories)) {
                return IndexCapability.ORDER_BOTH;
            }
            return IndexCapability.ORDER_NONE;
        }

        public IndexValueCapability valueCapability(ValueCategory ... valueCategories) {
            return IndexValueCapability.YES;
        }

        private boolean supportOrdering(ValueCategory[] valueCategories) {
            for (ValueCategory valueCategory : valueCategories) {
                if (valueCategory != ValueCategory.GEOMETRY && valueCategory != ValueCategory.GEOMETRY_ARRAY && valueCategory != ValueCategory.UNKNOWN) continue;
                return false;
            }
            return true;
        }

        public IndexLimitation[] limitations() {
            return this.limitations;
        }
    }
}

