/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.Iterator;
import org.neo4j.internal.kernel.api.LabelSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.PropertyCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.api.AssertOpen;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.TraceableCursor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.txstate.EntityState;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueGroup;

public class DefaultPropertyCursor
extends TraceableCursor
implements PropertyCursor {
    private static final long NO_NODE = -1L;
    private static final long NO_RELATIONSHIP = -1L;
    private Read read;
    private StoragePropertyCursor storeCursor;
    private EntityState propertiesState;
    private Iterator<StorageProperty> txStateChangedProperties;
    private StorageProperty txStateValue;
    private AssertOpen assertOpen;
    private final CursorPool<DefaultPropertyCursor> pool;
    private AccessMode accessMode;
    private long nodeReference = -1L;
    private long relationshipReference = -1L;
    private LabelSet labels;

    DefaultPropertyCursor(CursorPool<DefaultPropertyCursor> pool, StoragePropertyCursor storeCursor) {
        this.pool = pool;
        this.storeCursor = storeCursor;
    }

    void initNode(long nodeReference, long reference, Read read, AssertOpen assertOpen) {
        assert (nodeReference != -1L);
        this.init(read, assertOpen);
        this.storeCursor.initNodeProperties(reference);
        this.nodeReference = nodeReference;
        this.relationshipReference = -1L;
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getNodeState(nodeReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties();
        } else {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
        }
    }

    void initRelationship(long relationshipReference, long reference, Read read, AssertOpen assertOpen) {
        assert (relationshipReference != -1L);
        this.init(read, assertOpen);
        this.storeCursor.initRelationshipProperties(reference);
        this.nodeReference = -1L;
        this.relationshipReference = relationshipReference;
        if (read.hasTxStateWithChanges()) {
            this.propertiesState = read.txState().getRelationshipState(relationshipReference);
            this.txStateChangedProperties = this.propertiesState.addedAndChangedProperties();
        } else {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
        }
    }

    private void init(Read read, AssertOpen assertOpen) {
        this.assertOpen = assertOpen;
        this.read = read;
        this.accessMode = read.ktx.securityContext().mode();
        this.labels = null;
    }

    boolean allowed() {
        int propertyKey = this.propertyKey();
        if (this.isNode()) {
            return this.accessMode.allowsReadNodeProperty(this::labelsIgnoringTxStateSetRemove, propertyKey);
        }
        if (this.isRelationship()) {
            return this.accessMode.allowsReadRelationshipProperty(this::getRelType, propertyKey);
        }
        return true;
    }

    public boolean next() {
        if (this.txStateChangedProperties != null) {
            if (this.txStateChangedProperties.hasNext()) {
                this.txStateValue = this.txStateChangedProperties.next();
                if (this.tracer != null) {
                    this.tracer.onProperty(this.propertyKey());
                }
                return true;
            }
            this.txStateChangedProperties = null;
            this.txStateValue = null;
        }
        while (this.storeCursor.next()) {
            boolean skip = this.propertiesState != null && this.propertiesState.isPropertyChangedOrRemoved(this.storeCursor.propertyKey());
            if (skip || !this.allowed()) continue;
            if (this.tracer != null) {
                this.tracer.onProperty(this.propertyKey());
            }
            return true;
        }
        return false;
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            this.propertiesState = null;
            this.txStateChangedProperties = null;
            this.txStateValue = null;
            this.read = null;
            this.storeCursor.reset();
            this.accessMode = null;
            this.pool.accept(this);
        }
    }

    public int propertyKey() {
        if (this.txStateValue != null) {
            return this.txStateValue.propertyKeyId();
        }
        return this.storeCursor.propertyKey();
    }

    public ValueGroup propertyType() {
        if (this.txStateValue != null) {
            return this.txStateValue.value().valueGroup();
        }
        return this.storeCursor.propertyType();
    }

    public Value propertyValue() {
        if (this.txStateValue != null) {
            return this.txStateValue.value();
        }
        Value value = this.storeCursor.propertyValue();
        this.assertOpen.assertOpen();
        return value;
    }

    public boolean isClosed() {
        return this.read == null;
    }

    public String toString() {
        if (this.isClosed()) {
            return "PropertyCursor[closed state]";
        }
        return "PropertyCursor[id=" + this.propertyKey() + ", " + this.storeCursor.toString() + " ]";
    }

    public LabelSet labelsIgnoringTxStateSetRemove() {
        assert (this.isNode());
        if (this.labels == null) {
            try (NodeCursor nodeCursor = this.read.cursors().allocateFullAccessNodeCursor();){
                this.read.singleNode(this.nodeReference, nodeCursor);
                nodeCursor.next();
                this.labels = nodeCursor.labelsIgnoringTxStateSetRemove();
            }
        }
        return this.labels;
    }

    private int getRelType() {
        assert (this.isRelationship());
        try (RelationshipScanCursor relCursor = this.read.cursors().allocateFullAccessRelationshipScanCursor();){
            this.read.singleRelationship(this.relationshipReference, relCursor);
            relCursor.next();
            int n = relCursor.type();
            return n;
        }
    }

    public void release() {
        this.storeCursor.close();
    }

    private boolean isNode() {
        return this.nodeReference != -1L;
    }

    private boolean isRelationship() {
        return this.relationshipReference != -1L;
    }
}

