/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultRelationshipCursor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.storageengine.api.AllRelationshipsScan;
import org.neo4j.storageengine.api.Scan;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;

class DefaultRelationshipScanCursor
extends DefaultRelationshipCursor<StorageRelationshipScanCursor>
implements RelationshipScanCursor {
    private int type;
    private long single;
    private LongIterator addedRelationships;
    private CursorPool<DefaultRelationshipScanCursor> pool;

    DefaultRelationshipScanCursor(CursorPool<DefaultRelationshipScanCursor> pool, StorageRelationshipScanCursor storeCursor) {
        super(storeCursor);
        this.pool = pool;
    }

    void scan(int type, Read read) {
        ((StorageRelationshipScanCursor)this.storeCursor).scan(type);
        this.type = type;
        this.single = -1L;
        this.init(read);
        this.addedRelationships = ImmutableEmptyLongIterator.INSTANCE;
    }

    boolean scanBatch(Read read, AllRelationshipsScan scan, int sizeHint, LongIterator addedRelationships, boolean hasChanges) {
        this.read = read;
        this.single = -1L;
        this.type = -1;
        this.currentAddedInTx = -1L;
        this.addedRelationships = addedRelationships;
        this.hasChanges = hasChanges;
        this.checkHasChanges = false;
        boolean scanBatch = ((StorageRelationshipScanCursor)this.storeCursor).scanBatch((Scan)scan, sizeHint);
        return addedRelationships.hasNext() || scanBatch;
    }

    void single(long reference, Read read) {
        ((StorageRelationshipScanCursor)this.storeCursor).single(reference);
        this.type = -1;
        this.single = reference;
        this.init(read);
        this.addedRelationships = ImmutableEmptyLongIterator.INSTANCE;
    }

    public boolean next() {
        boolean hasChanges = this.hasChanges();
        if (hasChanges) {
            if (this.addedRelationships.hasNext()) {
                this.read.txState().relationshipVisit(this.addedRelationships.next(), this.relationshipTxStateDataVisitor);
                if (this.tracer != null) {
                    this.tracer.onRelationship(this.relationshipReference());
                }
                return true;
            }
            this.currentAddedInTx = -1L;
        }
        while (((StorageRelationshipScanCursor)this.storeCursor).next()) {
            boolean skip = hasChanges && this.read.txState().relationshipIsDeletedInThisTx(((StorageRelationshipScanCursor)this.storeCursor).entityReference());
            AccessMode mode = this.read.ktx.securityContext().mode();
            if (skip || !mode.allowsTraverseRelType(((StorageRelationshipScanCursor)this.storeCursor).type()) || !this.allowedToSeeEndNode(mode)) continue;
            if (this.tracer != null) {
                this.tracer.onRelationship(this.relationshipReference());
            }
            return true;
        }
        return false;
    }

    protected boolean allowedToSeeEndNode(AccessMode mode) {
        if (mode.allowsTraverseAllLabels()) {
            return true;
        }
        try (NodeCursor sourceNode = this.read.cursors().allocateNodeCursor();){
            boolean bl;
            block13: {
                NodeCursor targetNode = this.read.cursors().allocateNodeCursor();
                try {
                    this.read.singleNode(((StorageRelationshipScanCursor)this.storeCursor).sourceNodeReference(), sourceNode);
                    this.read.singleNode(((StorageRelationshipScanCursor)this.storeCursor).targetNodeReference(), targetNode);
                    boolean bl2 = bl = sourceNode.next() && targetNode.next();
                    if (targetNode == null) break block13;
                }
                catch (Throwable throwable) {
                    if (targetNode != null) {
                        try {
                            targetNode.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                targetNode.close();
            }
            return bl;
        }
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            this.read = null;
            ((StorageRelationshipScanCursor)this.storeCursor).close();
            this.pool.accept(this);
        }
    }

    public boolean isClosed() {
        return this.read == null;
    }

    public String toString() {
        if (this.isClosed()) {
            return "RelationshipScanCursor[closed state]";
        }
        return "RelationshipScanCursor[id=" + ((StorageRelationshipScanCursor)this.storeCursor).entityReference() + ", open state with: single=" + this.single + ", type=" + this.type + ", " + ((StorageRelationshipScanCursor)this.storeCursor).toString() + "]";
    }

    @Override
    protected void collectAddedTxStateSnapshot() {
        this.addedRelationships = this.isSingle() ? (this.read.txState().relationshipIsAddedInThisTx(this.single) ? LongHashSet.newSetWith((long[])new long[]{this.single}).longIterator() : ImmutableEmptyLongIterator.INSTANCE) : this.read.txState().addedAndRemovedRelationships().getAdded().longIterator();
    }

    private boolean isSingle() {
        return this.single != -1L;
    }

    public void release() {
        ((StorageRelationshipScanCursor)this.storeCursor).close();
    }
}

