/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.RelationshipScanCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.values.storable.Value;

class RelationshipSecurityFilter
implements IndexProgressor.EntityValueClient,
IndexProgressor {
    private final IndexProgressor.EntityValueClient target;
    private final Read read;
    private final RelationshipScanCursor relCursor;
    private final AccessMode accessMode;
    private final int[] properties;
    private IndexProgressor progressor;

    RelationshipSecurityFilter(int[] properties, IndexProgressor.EntityValueClient target, RelationshipScanCursor relCursor, Read read, AccessMode accessMode) {
        this.target = target;
        this.read = read;
        this.relCursor = relCursor;
        this.accessMode = accessMode;
        this.properties = properties;
    }

    public boolean next() {
        return this.progressor.next();
    }

    public void close() {
        IOUtils.close(RuntimeException::new, (AutoCloseable[])new AutoCloseable[]{this.relCursor, this.progressor});
    }

    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query, IndexOrder indexOrder, boolean needsValues, boolean indexIncludesTransactionState) {
        this.progressor = progressor;
        this.target.initialize(descriptor, (IndexProgressor)this, query, indexOrder, needsValues, indexIncludesTransactionState);
    }

    public boolean acceptEntity(long reference, float score, Value ... values) {
        this.read.singleRelationship(reference, this.relCursor);
        if (!this.relCursor.next()) {
            return false;
        }
        int relType = this.relCursor.type();
        for (int prop : this.properties) {
            if (this.accessMode.allowsReadRelationshipProperty(() -> relType, prop)) continue;
            return false;
        }
        return this.target.acceptEntity(reference, score, values);
    }

    public boolean needsValues() {
        return this.target.needsValues();
    }
}

