/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.IOException;
import java.util.List;
import org.neo4j.configuration.Config;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.storemigration.IndexConfigMigrator;
import org.neo4j.kernel.impl.storemigration.IndexProviderMigrator;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.kernel.impl.storemigration.StoreUpgrader;
import org.neo4j.kernel.impl.storemigration.VisibleMigrationProgressMonitor;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.logging.internal.LogService;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;

public class DatabaseMigrator {
    private final FileSystemAbstraction fs;
    private final Config config;
    private final LogService logService;
    private final IndexProviderMap indexProviderMap;
    private final PageCache pageCache;
    private final LogTailScanner tailScanner;
    private final JobScheduler jobScheduler;
    private final DatabaseLayout databaseLayout;
    private final LegacyTransactionLogsLocator legacyLogsLocator;
    private final StorageEngineFactory storageEngineFactory;

    public DatabaseMigrator(FileSystemAbstraction fs, Config config, LogService logService, IndexProviderMap indexProviderMap, PageCache pageCache, LogTailScanner tailScanner, JobScheduler jobScheduler, DatabaseLayout databaseLayout, LegacyTransactionLogsLocator legacyLogsLocator, StorageEngineFactory storageEngineFactory) {
        this.fs = fs;
        this.config = config;
        this.logService = logService;
        this.indexProviderMap = indexProviderMap;
        this.pageCache = pageCache;
        this.tailScanner = tailScanner;
        this.jobScheduler = jobScheduler;
        this.databaseLayout = databaseLayout;
        this.legacyLogsLocator = legacyLogsLocator;
        this.storageEngineFactory = storageEngineFactory;
    }

    public void migrate() throws IOException {
        StoreVersionCheck storeVersionCheck = this.storageEngineFactory.versionCheck(this.fs, this.databaseLayout, this.config, this.pageCache, this.logService);
        StoreUpgrader storeUpgrader = new StoreUpgrader(storeVersionCheck, new VisibleMigrationProgressMonitor(this.logService.getUserLog(DatabaseMigrator.class)), this.config, this.fs, this.logService.getInternalLogProvider(), this.tailScanner, this.legacyLogsLocator);
        List storeParticipants = this.storageEngineFactory.migrationParticipants(this.fs, this.config, this.pageCache, this.jobScheduler, this.logService);
        storeParticipants.forEach(storeUpgrader::addParticipant);
        IndexConfigMigrator indexConfigMigrator = new IndexConfigMigrator(this.fs, this.config, this.pageCache, this.logService, this.storageEngineFactory, this.indexProviderMap, this.logService.getUserLog(IndexConfigMigrator.class));
        storeUpgrader.addParticipant((StoreMigrationParticipant)indexConfigMigrator);
        IndexProviderMigrator indexProviderMigrator = new IndexProviderMigrator(this.fs, this.config, this.pageCache, this.logService, this.storageEngineFactory);
        storeUpgrader.addParticipant((StoreMigrationParticipant)indexProviderMigrator);
        this.indexProviderMap.accept(provider -> storeUpgrader.addParticipant(provider.storeMigrationParticipant(this.fs, this.pageCache, this.storageEngineFactory)));
        storeUpgrader.migrateIfNeeded(this.databaseLayout);
    }
}

