/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.storemigration;

import java.io.File;
import java.io.IOException;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.dbms.database.DatabaseConfig;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.storemigration.DatabaseMigrator;
import org.neo4j.kernel.impl.storemigration.LegacyTransactionLogsLocator;
import org.neo4j.kernel.impl.transaction.log.LogVersionUpgradeChecker;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryReader;
import org.neo4j.kernel.impl.transaction.log.entry.VersionAwareLogEntryReader;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogFilesBuilder;
import org.neo4j.kernel.recovery.LogTailScanner;
import org.neo4j.logging.internal.LogService;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.StorageEngineFactory;

public class DatabaseMigratorFactory {
    private final FileSystemAbstraction fs;
    private final Config config;
    private final LogService logService;
    private final PageCache pageCache;
    private final JobScheduler jobScheduler;
    private final NamedDatabaseId namedDatabaseId;

    public DatabaseMigratorFactory(FileSystemAbstraction fs, Config config, LogService logService, PageCache pageCache, JobScheduler jobScheduler, NamedDatabaseId namedDatabaseId) {
        this.fs = fs;
        this.config = config;
        this.logService = logService;
        this.pageCache = pageCache;
        this.jobScheduler = jobScheduler;
        this.namedDatabaseId = namedDatabaseId;
    }

    public DatabaseMigrator createDatabaseMigrator(DatabaseLayout databaseLayout, StorageEngineFactory storageEngineFactory, DependencyResolver dependencyResolver) {
        LogFiles logFiles;
        DatabaseConfig dbConfig = new DatabaseConfig(this.config, this.namedDatabaseId);
        IndexProviderMap indexProviderMap = (IndexProviderMap)dependencyResolver.resolveDependency(IndexProviderMap.class);
        Monitors monitors = (Monitors)dependencyResolver.resolveDependency(Monitors.class);
        VersionAwareLogEntryReader logEntryReader = new VersionAwareLogEntryReader();
        LegacyTransactionLogsLocator logsLocator = new LegacyTransactionLogsLocator(dbConfig, databaseLayout);
        try {
            LegacyDatabaseLayout oldDatabaseLayout = new LegacyDatabaseLayout(databaseLayout.getNeo4jLayout(), databaseLayout.getDatabaseName(), logsLocator);
            logFiles = LogFilesBuilder.builder(oldDatabaseLayout, this.fs).withLogEntryReader((LogEntryReader)logEntryReader).withConfig(dbConfig).withDependencies(dependencyResolver).build();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        LogTailScanner tailScanner = new LogTailScanner(logFiles, (LogEntryReader)logEntryReader, monitors, (Boolean)dbConfig.get(GraphDatabaseSettings.fail_on_corrupted_log_files));
        LogVersionUpgradeChecker.check(tailScanner, dbConfig);
        return new DatabaseMigrator(this.fs, dbConfig, this.logService, indexProviderMap, this.pageCache, tailScanner, this.jobScheduler, databaseLayout, logsLocator, storageEngineFactory);
    }

    private static class LegacyDatabaseLayout
    extends DatabaseLayout {
        private final LegacyTransactionLogsLocator logsLocator;

        LegacyDatabaseLayout(Neo4jLayout storeLayout, String databaseName, LegacyTransactionLogsLocator logsLocator) {
            super(storeLayout, databaseName);
            this.logsLocator = logsLocator;
        }

        public File getTransactionLogsDirectory() {
            return this.logsLocator.getTransactionLogsDirectory();
        }
    }
}

