/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.stats;

import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.ToLongFunction;
import org.neo4j.kernel.impl.transaction.stats.DatabaseTransactionStats;
import org.neo4j.kernel.impl.transaction.stats.TransactionCounters;

public class GlobalTransactionStats
implements TransactionCounters {
    private final CopyOnWriteArrayList<TransactionCounters> databasesCounters = new CopyOnWriteArrayList();

    @Override
    public long getPeakConcurrentNumberOfTransactions() {
        return -1L;
    }

    @Override
    public long getNumberOfStartedTransactions() {
        return this.sumCounters(TransactionCounters::getNumberOfStartedTransactions);
    }

    @Override
    public long getNumberOfCommittedTransactions() {
        return this.sumCounters(TransactionCounters::getNumberOfCommittedTransactions);
    }

    @Override
    public long getNumberOfCommittedReadTransactions() {
        return this.sumCounters(TransactionCounters::getNumberOfCommittedReadTransactions);
    }

    @Override
    public long getNumberOfCommittedWriteTransactions() {
        return this.sumCounters(TransactionCounters::getNumberOfCommittedWriteTransactions);
    }

    @Override
    public long getNumberOfActiveTransactions() {
        return this.sumCounters(TransactionCounters::getNumberOfActiveTransactions);
    }

    @Override
    public long getNumberOfActiveReadTransactions() {
        return this.sumCounters(TransactionCounters::getNumberOfActiveReadTransactions);
    }

    @Override
    public long getNumberOfActiveWriteTransactions() {
        return this.sumCounters(TransactionCounters::getNumberOfActiveWriteTransactions);
    }

    @Override
    public long getNumberOfTerminatedTransactions() {
        return this.sumCounters(TransactionCounters::getNumberOfTerminatedTransactions);
    }

    @Override
    public long getNumberOfTerminatedReadTransactions() {
        return this.sumCounters(TransactionCounters::getNumberOfTerminatedReadTransactions);
    }

    @Override
    public long getNumberOfTerminatedWriteTransactions() {
        return this.sumCounters(TransactionCounters::getNumberOfTerminatedWriteTransactions);
    }

    @Override
    public long getNumberOfRolledBackTransactions() {
        return this.sumCounters(TransactionCounters::getNumberOfRolledBackTransactions);
    }

    @Override
    public long getNumberOfRolledBackReadTransactions() {
        return this.sumCounters(TransactionCounters::getNumberOfRolledBackReadTransactions);
    }

    @Override
    public long getNumberOfRolledBackWriteTransactions() {
        return this.sumCounters(TransactionCounters::getNumberOfRolledBackWriteTransactions);
    }

    public DatabaseTransactionStats createDatabaseTransactionMonitor() {
        DatabaseTransactionStats transactionStats = new DatabaseTransactionStats();
        this.databasesCounters.add(transactionStats);
        return transactionStats;
    }

    private long sumCounters(ToLongFunction<TransactionCounters> mappingFunction) {
        return this.databasesCounters.stream().mapToLong(mappingFunction).sum();
    }
}

