/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.traversal;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.BranchSelector;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.InitialBranchState;
import org.neo4j.graphdb.traversal.PathEvaluator;
import org.neo4j.graphdb.traversal.TraversalBranch;
import org.neo4j.graphdb.traversal.TraversalContext;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.graphdb.traversal.UniquenessFilter;
import org.neo4j.kernel.impl.traversal.AbstractTraverserIterator;
import org.neo4j.kernel.impl.traversal.AsOneStartBranch;

class MonoDirectionalTraverserIterator
extends AbstractTraverserIterator {
    private final BranchSelector selector;
    private final PathEvaluator evaluator;
    private final UniquenessFilter uniqueness;

    MonoDirectionalTraverserIterator(UniquenessFilter uniqueness, PathExpander expander, BranchOrderingPolicy order, PathEvaluator evaluator, Iterable<Node> startNodes, InitialBranchState initialState, UniquenessFactory uniquenessFactory) {
        this.uniqueness = uniqueness;
        this.evaluator = evaluator;
        this.selector = order.create((TraversalBranch)new AsOneStartBranch(this, startNodes, initialState, uniquenessFactory), expander);
    }

    public Evaluation evaluate(TraversalBranch branch, BranchState state) {
        return this.evaluator.evaluate((Path)branch, state);
    }

    protected Path fetchNextOrNull() {
        TraversalBranch result;
        do {
            if ((result = this.selector.next((TraversalContext)this)) != null) continue;
            return null;
        } while (!result.includes());
        ++this.numberOfPathsReturned;
        return result;
    }

    public boolean isUniqueFirst(TraversalBranch branch) {
        return this.uniqueness.checkFirst(branch);
    }

    public boolean isUnique(TraversalBranch branch) {
        return this.uniqueness.check(branch);
    }
}

