/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.util;

import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.Relationship;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.values.virtual.NodeValue;
import org.neo4j.values.virtual.PathValue;
import org.neo4j.values.virtual.RelationshipValue;

public class PathWrappingPathValue
extends PathValue {
    private final Path path;

    PathWrappingPathValue(Path path) {
        this.path = path;
    }

    public NodeValue startNode() {
        return ValueUtils.fromNodeEntity(this.path.startNode());
    }

    public NodeValue endNode() {
        return ValueUtils.fromNodeEntity(this.path.endNode());
    }

    public RelationshipValue lastRelationship() {
        return ValueUtils.fromRelationshipEntity(this.path.lastRelationship());
    }

    public NodeValue[] nodes() {
        int length = this.path.length() + 1;
        NodeValue[] values = new NodeValue[length];
        int i = 0;
        for (Node node : this.path.nodes()) {
            values[i++] = ValueUtils.fromNodeEntity(node);
        }
        return values;
    }

    public RelationshipValue[] relationships() {
        int length = this.path.length();
        RelationshipValue[] values = new RelationshipValue[length];
        int i = 0;
        for (Relationship relationship : this.path.relationships()) {
            values[i++] = ValueUtils.fromRelationshipEntity(relationship);
        }
        return values;
    }

    public Path path() {
        return this.path;
    }
}

