/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.internal;

import java.io.File;
import java.io.FileFilter;
import java.nio.file.Path;
import org.neo4j.kernel.api.index.IndexDirectoryStructure;

public class NativeIndexFileFilter
implements FileFilter {
    private final Path indexRoot;

    public NativeIndexFileFilter(File storeDir) {
        this.indexRoot = IndexDirectoryStructure.baseSchemaIndexFolder((File)storeDir).toPath().toAbsolutePath();
    }

    @Override
    public boolean accept(File file) {
        Path path = file.toPath();
        if (!path.toAbsolutePath().startsWith(this.indexRoot)) {
            return false;
        }
        Path schemaPath = this.indexRoot.relativize(path);
        int nameCount = schemaPath.getNameCount();
        boolean isDeprecatedProviderFile = nameCount >= 1 && (schemaPath.getName(0).toString().equals("lucene") || schemaPath.getName(0).toString().equals("lucene_native-1.0") || schemaPath.getName(0).toString().equals("lucene_native-2.0"));
        boolean isFusionLuceneProviderFile = nameCount >= 3 && schemaPath.getName(2).toString().startsWith("lucene-");
        return !isDeprecatedProviderFile && !isFusionLuceneProviderFile;
    }
}

