/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import org.neo4j.function.ThrowingConsumer;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.TransactionImpl;

public interface SystemGraphComponent {
    public String component();

    public Status detect(Transaction var1);

    public void initializeSystemGraph(GraphDatabaseService var1) throws Exception;

    public void upgradeToCurrent(GraphDatabaseService var1) throws Exception;

    public static void executeWithFullAccess(GraphDatabaseService system, ThrowingConsumer<Transaction, Exception> consumer) throws Exception {
        try (TransactionImpl tx = (TransactionImpl)system.beginTx();
             KernelTransaction.Revertable ignore = tx.kernelTransaction().overrideWith(SecurityContext.AUTH_DISABLED);){
            consumer.accept((Object)tx);
            tx.commit();
        }
    }

    public static enum Status {
        UNINITIALIZED("No sub-graph detected for this component", "requires initialization"),
        CURRENT("The sub-graph is already at the current version", "nothing to do"),
        REQUIRES_UPGRADE("The sub-graph is supported, but is an older version and requires upgrade", "CALL dbms.upgrade()"),
        UNSUPPORTED_BUT_CAN_UPGRADE("The sub-graph is unsupported, this component cannot function", "Restart Neo4j in single-instance mode to upgrade this component at startup"),
        UNSUPPORTED("The sub-graph is unsupported because it is too old, this component cannot function", "Downgrade Neo4j and then upgrade this component before upgrading Neo4j again"),
        UNSUPPORTED_FUTURE("The sub-graph is unsupported because it is a newer version, this component cannot function", "Upgrade Neo4j");

        private final String description;
        private final String resolution;

        private Status(String description, String resolution) {
            this.description = description;
            this.resolution = resolution;
        }

        public Status with(Status other) {
            Status[] precedence;
            for (Status status : precedence = new Status[]{UNSUPPORTED_FUTURE, UNSUPPORTED, UNSUPPORTED_BUT_CAN_UPGRADE, REQUIRES_UPGRADE, UNINITIALIZED, CURRENT}) {
                if (other != status && this != status) continue;
                return status;
            }
            return this;
        }

        public String description() {
            return this.description;
        }

        public String resolution() {
            return this.resolution;
        }
    }
}

