/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.diagnostics.providers;

import java.util.Collection;
import java.util.List;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseManager;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.diagnostics.DiagnosticsManager;
import org.neo4j.internal.diagnostics.DiagnosticsProvider;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.diagnostics.providers.ConfigDiagnostics;
import org.neo4j.kernel.diagnostics.providers.StoreFilesDiagnostics;
import org.neo4j.kernel.diagnostics.providers.SystemDiagnostics;
import org.neo4j.kernel.diagnostics.providers.TransactionRangeDiagnostics;
import org.neo4j.kernel.diagnostics.providers.VersionDiagnostics;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.util.FeatureToggles;

public class DbmsDiagnosticsManager {
    private static final int CONCISE_DATABASE_DUMP_THRESHOLD = FeatureToggles.getInteger(DbmsDiagnosticsManager.class, (String)"conciseDumpThreshold", (int)10);
    private static final int CONCISE_DATABASE_NAMES_PER_ROW = 5;
    private final Dependencies dependencies;
    private final boolean enabled;
    private final Log log;

    public DbmsDiagnosticsManager(Dependencies dependencies, LogService logService) {
        this.log = logService.getInternalLog(DiagnosticsManager.class);
        this.dependencies = dependencies;
        this.enabled = (Boolean)((Config)dependencies.resolveDependency(Config.class)).get(GraphDatabaseInternalSettings.dump_diagnostics);
    }

    public void dumpSystemDiagnostics() {
        if (this.enabled) {
            this.dumpSystemDiagnostics(this.log);
        }
    }

    public void dumpDatabaseDiagnostics(Database database) {
        if (this.enabled) {
            this.dumpDatabaseDiagnostics(database, this.log, false);
        }
    }

    public void dumpAll() {
        this.dumpAll(this.log);
    }

    public void dumpAll(Log log) {
        if (this.enabled) {
            this.dumpSystemDiagnostics(log);
            this.dumpAllDatabases(log);
        }
    }

    private void dumpAllDatabases(Log log) {
        Collection<?> values = this.getDatabaseManager().registeredDatabases().values();
        if (values.size() > CONCISE_DATABASE_DUMP_THRESHOLD) {
            this.dumpConciseDiagnostics(values, log);
        } else {
            values.forEach(dbCtx -> this.dumpDatabaseDiagnostics(dbCtx.database(), log, true));
        }
    }

    private void dumpConciseDiagnostics(Collection<? extends DatabaseContext> databaseContexts, Log log) {
        List startedDbs = databaseContexts.stream().map(DatabaseContext::database).filter(Database::isStarted).collect(Collectors.toList());
        List stoppedDbs = databaseContexts.stream().map(DatabaseContext::database).filter(Predicate.not(Database::isStarted)).collect(Collectors.toList());
        this.dumpAsSingleMessage(log, stringJoiner -> {
            this.logDatabasesState(stringJoiner::add, startedDbs, "Started");
            this.logDatabasesState(stringJoiner::add, stoppedDbs, "Stopped");
        });
    }

    private void logDatabasesState(DiagnosticsLogger log, List<Database> databases, String state) {
        DiagnosticsManager.section((DiagnosticsLogger)log, (String)(state + " Databases"));
        if (databases.isEmpty()) {
            log.log(String.format("There are no %s databases", state.toLowerCase()));
            return;
        }
        int lastIndex = 0;
        for (int i = 5; i < databases.size(); i += 5) {
            List<Database> subList = databases.subList(lastIndex, i);
            this.logDatabases(log, subList);
            lastIndex = i;
        }
        List<Database> lastDbs = databases.subList(lastIndex, databases.size());
        this.logDatabases(log, lastDbs);
    }

    private void logDatabases(DiagnosticsLogger log, List<Database> subList) {
        log.log(subList.stream().map(database -> database.getNamedDatabaseId().name()).collect(Collectors.joining(", ")));
    }

    private void dumpSystemDiagnostics(Log log) {
        this.dumpAsSingleMessage(log, stringJoiner -> {
            DiagnosticsManager.section(stringJoiner::add, (String)"System diagnostics");
            DiagnosticsManager.dump(SystemDiagnostics.class, (Log)log, stringJoiner::add);
            DiagnosticsManager.dump((DiagnosticsProvider)new ConfigDiagnostics((Config)this.dependencies.resolveDependency(Config.class)), (Log)log, stringJoiner::add);
            this.dependencies.resolveTypeDependencies(DiagnosticsProvider.class).forEach(provider -> DiagnosticsManager.dump((DiagnosticsProvider)provider, (Log)log, stringJoiner::add));
        });
    }

    private void dumpDatabaseDiagnostics(Database database, Log log, boolean checkStatus) {
        this.dumpAsSingleMessageWithDbPrefix(log, stringJoiner -> {
            this.dumpDatabaseSectionName(database, stringJoiner::add);
            if (checkStatus) {
                DbmsDiagnosticsManager.logDatabaseStatus(database, stringJoiner::add);
                if (!database.isStarted()) {
                    return;
                }
            }
            Dependencies databaseResolver = database.getDependencyResolver();
            DbmsInfo dbmsInfo = (DbmsInfo)((Object)((Object)databaseResolver.resolveDependency(DbmsInfo.class)));
            FileSystemAbstraction fs = (FileSystemAbstraction)databaseResolver.resolveDependency(FileSystemAbstraction.class);
            StorageEngineFactory storageEngineFactory = (StorageEngineFactory)databaseResolver.resolveDependency(StorageEngineFactory.class);
            StorageEngine storageEngine = (StorageEngine)databaseResolver.resolveDependency(StorageEngine.class);
            DiagnosticsManager.dump((DiagnosticsProvider)new VersionDiagnostics(dbmsInfo, database.getStoreId()), (Log)log, stringJoiner::add);
            DiagnosticsManager.dump((DiagnosticsProvider)new StoreFilesDiagnostics(storageEngineFactory, fs, database.getDatabaseLayout()), (Log)log, stringJoiner::add);
            DiagnosticsManager.dump((DiagnosticsProvider)new TransactionRangeDiagnostics(database), (Log)log, stringJoiner::add);
            storageEngine.dumpDiagnostics(log, stringJoiner::add);
        }, database.getNamedDatabaseId());
    }

    private void dumpAsSingleMessageWithDbPrefix(Log log, Consumer<StringJoiner> dumpFunction, NamedDatabaseId db) {
        this.dumpAsSingleMessageWithPrefix(log, dumpFunction, "[" + db.logPrefix() + "] ");
    }

    private void dumpAsSingleMessage(Log log, Consumer<StringJoiner> dumpFunction) {
        this.dumpAsSingleMessageWithPrefix(log, dumpFunction, "");
    }

    private void dumpAsSingleMessageWithPrefix(Log log, Consumer<StringJoiner> dumpFunction, String prefix) {
        if (log == NullLog.getInstance()) {
            return;
        }
        StringJoiner message = new StringJoiner(System.lineSeparator() + " ".repeat(64) + prefix, prefix + System.lineSeparator() + " ".repeat(64) + prefix, "");
        dumpFunction.accept(message);
        log.info(message.toString());
    }

    private static void logDatabaseStatus(Database database, DiagnosticsLogger log) {
        log.log(String.format("Database is %s.", database.isStarted() ? "started" : "stopped"));
    }

    private void dumpDatabaseSectionName(Database database, DiagnosticsLogger log) {
        DiagnosticsManager.section((DiagnosticsLogger)log, (String)("Database: " + database.getNamedDatabaseId().name()));
    }

    private DatabaseManager<?> getDatabaseManager() {
        return (DatabaseManager)this.dependencies.resolveDependency(DatabaseManager.class);
    }
}

