/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.index.schema;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.index.internal.gbptree.GBPTree;
import org.neo4j.index.internal.gbptree.Seeker;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.index.IndexSample;
import org.neo4j.kernel.api.index.NonUniqueIndexSampler;
import org.neo4j.kernel.impl.index.schema.IndexLayout;
import org.neo4j.kernel.impl.index.schema.NativeIndexKey;
import org.neo4j.kernel.impl.index.schema.NativeIndexValue;

class FullScanNonUniqueIndexSampler<KEY extends NativeIndexKey<KEY>, VALUE extends NativeIndexValue>
extends NonUniqueIndexSampler.Adapter {
    private final GBPTree<KEY, VALUE> gbpTree;
    private final IndexLayout<KEY, VALUE> layout;

    FullScanNonUniqueIndexSampler(GBPTree<KEY, VALUE> gbpTree, IndexLayout<KEY, VALUE> layout) {
        this.gbpTree = gbpTree;
        this.layout = layout;
    }

    public IndexSample sample(PageCursorTracer cursorTracer) {
        IndexSample indexSample;
        block11: {
            NativeIndexKey lowest = (NativeIndexKey)((Object)this.layout.newKey());
            lowest.initialize(Long.MIN_VALUE);
            lowest.initValuesAsLowest();
            NativeIndexKey highest = (NativeIndexKey)((Object)this.layout.newKey());
            highest.initialize(Long.MAX_VALUE);
            highest.initValuesAsHighest();
            NativeIndexKey prev = (NativeIndexKey)((Object)this.layout.newKey());
            Seeker seek = this.gbpTree.seek((Object)lowest, (Object)highest, cursorTracer);
            try {
                long sampledValues = 0L;
                long uniqueValues = 0L;
                if (seek.next()) {
                    prev = (NativeIndexKey)((Object)this.layout.copyKey((Object)((NativeIndexKey)((Object)seek.key())), (Object)prev));
                    ++sampledValues;
                    ++uniqueValues;
                    while (seek.next()) {
                        if (this.layout.compareValue(prev, (NativeIndexKey)((Object)seek.key())) != 0) {
                            ++uniqueValues;
                            this.layout.copyKey((Object)((NativeIndexKey)((Object)seek.key())), (Object)prev);
                        }
                        ++sampledValues;
                    }
                }
                indexSample = new IndexSample(sampledValues, uniqueValues, sampledValues);
                if (seek == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (seek != null) {
                        try {
                            seek.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            seek.close();
        }
        return indexSample;
    }

    public IndexSample sample(int numDocs, PageCursorTracer cursorTracer) {
        throw new UnsupportedOperationException();
    }
}

