/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import java.io.Serializable;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.configuration.Config;
import org.neo4j.internal.helpers.collection.Visitor;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.locking.community.CommunityLockClient;
import org.neo4j.kernel.impl.locking.community.LockManagerImpl;
import org.neo4j.kernel.impl.locking.community.LockResource;
import org.neo4j.kernel.impl.locking.community.RWLock;
import org.neo4j.kernel.impl.locking.community.RagManager;
import org.neo4j.lock.LockType;
import org.neo4j.time.SystemNanoClock;

public class CommunityLockManger
implements Locks {
    private final LockManagerImpl manager;
    private volatile boolean closed;

    public CommunityLockManger(Config config, SystemNanoClock clock) {
        this.manager = new LockManagerImpl(new RagManager(), config, clock);
    }

    @Override
    public Locks.Client newClient() {
        if (this.closed) {
            throw new IllegalStateException(this + " already closed");
        }
        return new CommunityLockClient(this.manager);
    }

    @Override
    public void accept(Locks.Visitor visitor) {
        this.manager.accept((Visitor<RWLock, RuntimeException>)((Visitor)rwLock -> {
            LongSet transactionIds = rwLock.transactionIds();
            LockResource lockResource = rwLock.resource();
            transactionIds.forEach((LongProcedure & Serializable)txId -> visitor.visit(rwLock.getWriteCount() > 0 ? LockType.EXCLUSIVE : LockType.SHARED, lockResource.resourceType(), txId, lockResource.resourceId(), rwLock.describe(), rwLock.maxWaitTime(), System.identityHashCode(lockResource)));
            return false;
        }));
    }

    @Override
    public void close() {
        this.closed = true;
    }
}

