/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.community;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.neo4j.kernel.DeadlockDetectedException;
import org.neo4j.kernel.impl.locking.community.LockException;

public class RagManager {
    private final Map<Object, List<Object>> resourceMap = new HashMap<Object, List<Object>>();
    private final Map<Object, Object> waitingTxMap = new HashMap<Object, Object>();

    synchronized void lockAcquired(Object resource, Object tx) {
        List<Object> lockingTxList = this.resourceMap.get(resource);
        if (lockingTxList != null) {
            assert (!lockingTxList.contains(tx));
            lockingTxList.add(tx);
        } else {
            lockingTxList = new LinkedList<Object>();
            lockingTxList.add(tx);
            this.resourceMap.put(resource, lockingTxList);
        }
    }

    synchronized void lockReleased(Object resource, Object tx) {
        List<Object> lockingTxList = this.resourceMap.get(resource);
        if (lockingTxList == null) {
            throw new LockException(resource + " not found in resource map");
        }
        if (!lockingTxList.remove(tx)) {
            throw new LockException(tx + "not found in locking tx list");
        }
        if (lockingTxList.isEmpty()) {
            this.resourceMap.remove(resource);
        }
    }

    synchronized void stopWaitOn(Object resource, Object tx) {
        if (this.waitingTxMap.remove(tx) == null) {
            throw new LockException(tx + " not waiting on " + resource);
        }
    }

    synchronized void checkWaitOn(Object resource, Object tx) throws DeadlockDetectedException {
        List<Object> lockingTxList = this.resourceMap.get(resource);
        if (lockingTxList == null) {
            throw new LockException("Illegal resource[" + resource + "], not found in map");
        }
        if (this.waitingTxMap.get(tx) != null) {
            throw new LockException(tx + " already waiting for resource");
        }
        Iterator<Object> itr = lockingTxList.iterator();
        LinkedList<Object> checkedTransactions = new LinkedList<Object>();
        ArrayDeque<Object> graphStack = new ArrayDeque<Object>();
        graphStack.push(resource);
        while (itr.hasNext()) {
            Object lockingTx = itr.next();
            if (lockingTx.equals(tx)) continue;
            graphStack.push(lockingTx);
            this.checkWaitOnRecursive(lockingTx, tx, checkedTransactions, graphStack);
            graphStack.pop();
        }
        this.waitingTxMap.put(tx, resource);
    }

    private synchronized void checkWaitOnRecursive(Object lockingTx, Object waitingTx, List<Object> checkedTransactions, Deque<Object> graphStack) throws DeadlockDetectedException {
        if (lockingTx.equals(waitingTx)) {
            Object resource;
            StringBuilder circle = null;
            do {
                lockingTx = graphStack.pop();
                resource = graphStack.pop();
                if (circle == null) {
                    circle = new StringBuilder();
                    circle.append(lockingTx).append(" <-[:HELD_BY]- ").append(resource);
                    continue;
                }
                circle.append(" <-[:WAITING_FOR]- ").append(lockingTx).append(" <-[:HELD_BY]- ").append(resource);
            } while (!graphStack.isEmpty());
            throw new DeadlockDetectedException(waitingTx + " can't wait on resource " + resource + " since => " + circle);
        }
        checkedTransactions.add(lockingTx);
        Object resource = this.waitingTxMap.get(lockingTx);
        if (resource != null) {
            graphStack.push(resource);
            List<Object> lockingTxList = this.resourceMap.get(resource);
            if (lockingTxList != null) {
                for (Object aLockingTxList : lockingTxList) {
                    lockingTx = aLockingTxList;
                    if (checkedTransactions.contains(lockingTx)) continue;
                    graphStack.push(lockingTx);
                    this.checkWaitOnRecursive(lockingTx, waitingTx, checkedTransactions, graphStack);
                    graphStack.pop();
                }
            }
            graphStack.pop();
        }
    }
}

