/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.newapi;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.eclipse.collections.api.tuple.primitive.LongObjectPair;
import org.eclipse.collections.impl.factory.primitive.LongSets;
import org.eclipse.collections.impl.iterator.ImmutableEmptyLongIterator;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;
import org.neo4j.collection.PrimitiveLongCollections;
import org.neo4j.collection.trackable.HeapTrackingArrayList;
import org.neo4j.graphdb.Resource;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.ResourceClosingIterator;
import org.neo4j.internal.kernel.api.IndexQuery;
import org.neo4j.internal.kernel.api.IndexQueryConstraints;
import org.neo4j.internal.kernel.api.NodeCursor;
import org.neo4j.internal.kernel.api.NodeValueIndexCursor;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexOrder;
import org.neo4j.io.IOUtils;
import org.neo4j.kernel.api.index.IndexProgressor;
import org.neo4j.kernel.api.txstate.TransactionState;
import org.neo4j.kernel.impl.newapi.CursorPool;
import org.neo4j.kernel.impl.newapi.DefaultNodeCursor;
import org.neo4j.kernel.impl.newapi.EntityIndexSeekClient;
import org.neo4j.kernel.impl.newapi.IndexCursor;
import org.neo4j.kernel.impl.newapi.Labels;
import org.neo4j.kernel.impl.newapi.NodeWithPropertyValues;
import org.neo4j.kernel.impl.newapi.Read;
import org.neo4j.kernel.impl.newapi.SortedMergeJoin;
import org.neo4j.kernel.impl.newapi.TxStateIndexChanges;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueTuple;
import org.neo4j.values.storable.Values;

class DefaultNodeValueIndexCursor
extends IndexCursor<IndexProgressor>
implements NodeValueIndexCursor,
EntityIndexSeekClient,
SortedMergeJoin.Sink {
    private static final Comparator<LongObjectPair<Value[]>> ASCENDING_COMPARATOR = DefaultNodeValueIndexCursor.computeComparator((Comparator<Value>)Values.COMPARATOR);
    private static final Comparator<LongObjectPair<Value[]>> DESCENDING_COMPARATOR = DefaultNodeValueIndexCursor.computeComparator((o1, o2) -> -Values.COMPARATOR.compare(o1, o2));
    private Read read;
    private long node;
    private float score;
    private IndexQuery[] query;
    private Value[] values;
    private LongObjectPair<Value[]> cachedValues;
    private ResourceIterator<LongObjectPair<Value[]>> eagerPointIterator;
    private LongIterator added = ImmutableEmptyLongIterator.INSTANCE;
    private Iterator<NodeWithPropertyValues> addedWithValues = Collections.emptyIterator();
    private LongSet removed = LongSets.immutable.empty();
    private boolean needsValues;
    private IndexOrder indexOrder;
    private final MemoryTracker memoryTracker;
    private final CursorPool<DefaultNodeValueIndexCursor> pool;
    private final DefaultNodeCursor securityNodeCursor;
    private final SortedMergeJoin sortedMergeJoin = new SortedMergeJoin();
    private AccessMode accessMode;
    private boolean shortcutSecurity;
    private int[] propertyIds;

    DefaultNodeValueIndexCursor(CursorPool<DefaultNodeValueIndexCursor> pool, DefaultNodeCursor securityNodeCursor, MemoryTracker memoryTracker) {
        this.pool = pool;
        this.securityNodeCursor = securityNodeCursor;
        this.memoryTracker = memoryTracker;
        this.node = -1L;
        this.score = Float.NaN;
        this.indexOrder = IndexOrder.NONE;
    }

    public void initialize(IndexDescriptor descriptor, IndexProgressor progressor, IndexQuery[] query, IndexQueryConstraints constraints, boolean indexIncludesTransactionState) {
        assert (query != null);
        super.initialize(progressor);
        this.indexOrder = constraints.order();
        this.needsValues = constraints.needsValues();
        this.sortedMergeJoin.initialize(this.indexOrder);
        this.query = query;
        if (this.tracer != null) {
            this.tracer.onIndexSeek();
        }
        this.shortcutSecurity = this.setupSecurity(descriptor);
        if (!indexIncludesTransactionState && this.read.hasTxStateWithChanges() && query.length > 0) {
            int i;
            ArrayList<Value> exactQueryValues = new ArrayList<Value>(query.length);
            for (i = 0; i < query.length && query[i] instanceof IndexQuery.ExactPredicate; ++i) {
                exactQueryValues.add(((IndexQuery.ExactPredicate)query[i]).value());
            }
            Value[] exactValues = exactQueryValues.toArray(new Value[0]);
            if (i == query.length) {
                this.indexOrder = IndexOrder.NONE;
                this.seekQuery(descriptor, exactValues);
            } else {
                IndexQuery nextQuery = query[i];
                switch (nextQuery.type()) {
                    case exists: {
                        this.setNeedsValuesIfRequiresOrder();
                        if (exactQueryValues.isEmpty()) {
                            this.scanQuery(descriptor);
                            break;
                        }
                        this.rangeQuery(descriptor, exactValues, null);
                        break;
                    }
                    case range: {
                        this.setNeedsValuesIfRequiresOrder();
                        this.rangeQuery(descriptor, exactValues, (IndexQuery.RangePredicate)nextQuery);
                        break;
                    }
                    case stringPrefix: {
                        this.setNeedsValuesIfRequiresOrder();
                        this.prefixQuery(descriptor, exactValues, (IndexQuery.StringPrefixPredicate)nextQuery);
                        break;
                    }
                    case stringSuffix: 
                    case stringContains: {
                        assert (query.length == 1);
                        this.suffixOrContainsQuery(descriptor, nextQuery);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Query not supported: " + Arrays.toString(query));
                    }
                }
            }
        }
    }

    private boolean setupSecurity(IndexDescriptor descriptor) {
        long[] labelIds;
        if (this.allowsAll()) {
            return true;
        }
        if (this.accessMode == null) {
            this.accessMode = this.read.ktx.securityContext().mode();
        }
        this.propertyIds = descriptor.schema().getPropertyIds();
        for (long label : labelIds = Arrays.stream(descriptor.schema().getEntityTokenIds()).mapToLong(i -> i).toArray()) {
            if (this.accessMode.allowsTraverseAllNodesWithLabel(label)) continue;
            return false;
        }
        for (int propId : this.propertyIds) {
            if (this.accessMode.disallowsReadPropertyForSomeLabel(propId)) {
                return false;
            }
            for (long label : labelIds) {
                if (this.accessMode.allowsReadNodeProperty(() -> Labels.from(label), propId)) continue;
                return false;
            }
        }
        return true;
    }

    private void setNeedsValuesIfRequiresOrder() {
        if (this.indexOrder != IndexOrder.NONE) {
            this.needsValues = true;
        }
    }

    private boolean isRemoved(long reference) {
        return this.removed.contains(reference);
    }

    public boolean acceptEntity(long reference, float score, Value ... values) {
        if (this.isRemoved(reference) || !this.allowed(reference)) {
            return false;
        }
        this.node = reference;
        this.score = score;
        this.values = values;
        return true;
    }

    boolean allowed(long reference) {
        if (this.shortcutSecurity) {
            return true;
        }
        this.read.singleNode(reference, this.securityNodeCursor);
        if (!this.securityNodeCursor.next()) {
            return false;
        }
        boolean allowed = true;
        long[] labels = this.securityNodeCursor.labelsIgnoringTxStateSetRemove().all();
        for (int prop : this.propertyIds) {
            allowed &= this.accessMode.allowsReadNodeProperty(() -> Labels.from(labels), prop);
        }
        return allowed;
    }

    boolean allowsAll() {
        return false;
    }

    public boolean needsValues() {
        return this.needsValues;
    }

    public boolean next() {
        if (this.indexOrder == IndexOrder.NONE) {
            return this.nextWithoutOrder();
        }
        return this.nextWithOrdering();
    }

    private boolean nextWithoutOrder() {
        if (!this.needsValues && this.added.hasNext()) {
            this.node = this.added.next();
            this.values = null;
            if (this.tracer != null) {
                this.tracer.onNode(this.node);
            }
            return true;
        }
        if (this.needsValues && this.addedWithValues.hasNext()) {
            NodeWithPropertyValues nodeWithPropertyValues = this.addedWithValues.next();
            this.node = nodeWithPropertyValues.getNodeId();
            this.values = nodeWithPropertyValues.getValues();
            if (this.tracer != null) {
                this.tracer.onNode(this.node);
            }
            return true;
        }
        if (this.added.hasNext() || this.addedWithValues.hasNext()) {
            throw new IllegalStateException("Index cursor cannot have transaction state with values and without values simultaneously");
        }
        boolean next = this.innerNext();
        if (this.tracer != null && next) {
            this.tracer.onNode(this.node);
        }
        return next;
    }

    private boolean nextWithOrdering() {
        boolean next;
        if (this.sortedMergeJoin.needsA() && this.addedWithValues.hasNext()) {
            NodeWithPropertyValues nodeWithPropertyValues = this.addedWithValues.next();
            this.sortedMergeJoin.setA(nodeWithPropertyValues.getNodeId(), nodeWithPropertyValues.getValues());
        }
        if (this.sortedMergeJoin.needsB() && this.innerNextFromBuffer()) {
            this.sortedMergeJoin.setB(this.node, this.values);
        }
        this.sortedMergeJoin.next(this);
        boolean bl = next = this.node != -1L;
        if (this.tracer != null && next) {
            this.tracer.onNode(this.node);
        }
        return next;
    }

    private boolean innerNextFromBuffer() {
        if (this.eagerPointIterator != null) {
            return this.streamPointsFromIterator();
        }
        boolean innerNext = this.innerNext();
        if (this.values != null && innerNext && this.indexOrder != IndexOrder.NONE) {
            return this.eagerizingPoints();
        }
        return innerNext;
    }

    private boolean containsPoints() {
        for (Value value : this.values) {
            if (!(value instanceof PointValue) && !(value instanceof PointArray)) continue;
            return true;
        }
        return false;
    }

    private boolean eagerizingPoints() {
        HeapTrackingArrayList eagerPointBuffer = null;
        boolean shouldContinue = true;
        while (shouldContinue && this.containsPoints()) {
            if (eagerPointBuffer == null) {
                eagerPointBuffer = HeapTrackingArrayList.newArrayList((int)256, (MemoryTracker)this.memoryTracker);
            }
            eagerPointBuffer.add((Object)PrimitiveTuples.pair((long)this.node, (Object)Arrays.copyOf(this.values, this.values.length)));
            shouldContinue = this.innerNext();
        }
        if (eagerPointBuffer != null) {
            if (shouldContinue) {
                this.cachedValues = PrimitiveTuples.pair((long)this.node, (Object)Arrays.copyOf(this.values, this.values.length));
            }
            eagerPointBuffer.sort(this.comparator());
            this.eagerPointIterator = ResourceClosingIterator.newResourceIterator((Iterator)eagerPointBuffer.autoClosingIterator(), (Resource[])new Resource[]{this.asResource((AutoCloseable)eagerPointBuffer)});
            return this.streamPointsFromIterator();
        }
        return true;
    }

    private Resource asResource(AutoCloseable resource) {
        return () -> IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{resource});
    }

    private static Comparator<LongObjectPair<Value[]>> computeComparator(Comparator<Value> comparator) {
        return (o1, o2) -> {
            Value[] v1 = (Value[])o1.getTwo();
            Value[] v2 = (Value[])o2.getTwo();
            for (int i = 0; i < v1.length; ++i) {
                int compare = comparator.compare(v1[i], v2[i]);
                if (compare == 0) continue;
                return compare;
            }
            return 0;
        };
    }

    private Comparator<LongObjectPair<Value[]>> comparator() {
        switch (this.indexOrder) {
            case ASCENDING: {
                return ASCENDING_COMPARATOR;
            }
            case DESCENDING: {
                return DESCENDING_COMPARATOR;
            }
        }
        throw new IllegalStateException("can't sort if no indexOrder defined");
    }

    private boolean streamPointsFromIterator() {
        if (this.eagerPointIterator.hasNext()) {
            LongObjectPair nextPair = (LongObjectPair)this.eagerPointIterator.next();
            this.node = nextPair.getOne();
            this.values = (Value[])nextPair.getTwo();
            return true;
        }
        if (this.cachedValues != null) {
            this.values = (Value[])this.cachedValues.getTwo();
            this.node = this.cachedValues.getOne();
            this.eagerPointIterator = null;
            this.cachedValues = null;
            return true;
        }
        return false;
    }

    @Override
    public void acceptSortedMergeJoin(long nodeId, Value[] values) {
        this.node = nodeId;
        this.values = values;
    }

    @Override
    public void setRead(Read read) {
        this.read = read;
    }

    public void node(NodeCursor cursor) {
        this.read.singleNode(this.node, cursor);
    }

    public long nodeReference() {
        return this.node;
    }

    public int numberOfProperties() {
        return this.query == null ? 0 : this.query.length;
    }

    public int propertyKey(int offset) {
        return this.query[offset].propertyKeyId();
    }

    public boolean hasValue() {
        return this.values != null;
    }

    public float score() {
        return this.score;
    }

    public Value propertyValue(int offset) {
        return this.values[offset];
    }

    public void closeInternal() {
        if (!this.isClosed()) {
            this.closeProgressor();
            this.node = -1L;
            this.score = Float.NaN;
            this.query = null;
            this.values = null;
            this.read = null;
            this.accessMode = null;
            this.added = ImmutableEmptyLongIterator.INSTANCE;
            this.addedWithValues = Collections.emptyIterator();
            this.removed = LongSets.immutable.empty();
            if (this.eagerPointIterator != null) {
                this.eagerPointIterator.close();
            }
            this.pool.accept(this);
        }
    }

    public boolean isClosed() {
        return this.isProgressorClosed();
    }

    public String toString() {
        if (this.isClosed()) {
            return "NodeValueIndexCursor[closed state]";
        }
        String keys = this.query == null ? "unknown" : Arrays.toString(Arrays.stream(this.query).map(IndexQuery::propertyKeyId).toArray(Integer[]::new));
        return "NodeValueIndexCursor[node=" + this.node + ", open state with: keys=" + keys + ", values=" + Arrays.toString(this.values) + ", underlying record=" + super.toString() + "]";
    }

    private void prefixQuery(IndexDescriptor descriptor, Value[] equalityPrefix, IndexQuery.StringPrefixPredicate predicate) {
        TransactionState txState = this.read.txState();
        if (this.needsValues) {
            TxStateIndexChanges.AddedWithValuesAndRemoved changes = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeekByPrefix(txState, descriptor, equalityPrefix, predicate.prefix(), this.indexOrder);
            this.addedWithValues = changes.getAdded().iterator();
            this.removed = this.removed(txState, changes.getRemoved());
        } else {
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForRangeSeekByPrefix(txState, descriptor, equalityPrefix, predicate.prefix(), this.indexOrder);
            this.added = changes.getAdded().longIterator();
            this.removed = this.removed(txState, changes.getRemoved());
        }
    }

    private void rangeQuery(IndexDescriptor descriptor, Value[] equalityPrefix, IndexQuery.RangePredicate<?> predicate) {
        TransactionState txState = this.read.txState();
        if (this.needsValues) {
            TxStateIndexChanges.AddedWithValuesAndRemoved changes = TxStateIndexChanges.indexUpdatesWithValuesForRangeSeek(txState, descriptor, equalityPrefix, predicate, this.indexOrder);
            this.addedWithValues = changes.getAdded().iterator();
            this.removed = this.removed(txState, changes.getRemoved());
        } else {
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForRangeSeek(txState, descriptor, equalityPrefix, predicate, this.indexOrder);
            this.added = changes.getAdded().longIterator();
            this.removed = this.removed(txState, changes.getRemoved());
        }
    }

    private void scanQuery(IndexDescriptor descriptor) {
        TransactionState txState = this.read.txState();
        if (this.needsValues) {
            TxStateIndexChanges.AddedWithValuesAndRemoved changes = TxStateIndexChanges.indexUpdatesWithValuesForScan(txState, descriptor, this.indexOrder);
            this.addedWithValues = changes.getAdded().iterator();
            this.removed = this.removed(txState, changes.getRemoved());
        } else {
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForScan(txState, descriptor, this.indexOrder);
            this.added = changes.getAdded().longIterator();
            this.removed = this.removed(txState, changes.getRemoved());
        }
    }

    private void suffixOrContainsQuery(IndexDescriptor descriptor, IndexQuery query) {
        TransactionState txState = this.read.txState();
        if (this.needsValues) {
            TxStateIndexChanges.AddedWithValuesAndRemoved changes = TxStateIndexChanges.indexUpdatesWithValuesForSuffixOrContains(txState, descriptor, query, this.indexOrder);
            this.addedWithValues = changes.getAdded().iterator();
            this.removed = this.removed(txState, changes.getRemoved());
        } else {
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSuffixOrContains(txState, descriptor, query, this.indexOrder);
            this.added = changes.getAdded().longIterator();
            this.removed = this.removed(txState, changes.getRemoved());
        }
    }

    private void seekQuery(IndexDescriptor descriptor, Value[] values) {
        TransactionState txState = this.read.txState();
        if (this.needsValues) {
            TxStateIndexChanges.AddedWithValuesAndRemoved changes = TxStateIndexChanges.indexUpdatesWithValuesForSeek(txState, descriptor, ValueTuple.of((Value[])values));
            this.addedWithValues = changes.getAdded().iterator();
            this.removed = this.removed(txState, changes.getRemoved());
        } else {
            TxStateIndexChanges.AddedAndRemoved changes = TxStateIndexChanges.indexUpdatesForSeek(txState, descriptor, ValueTuple.of((Value[])values));
            this.added = changes.getAdded().longIterator();
            this.removed = this.removed(txState, changes.getRemoved());
        }
    }

    private LongSet removed(TransactionState txState, LongSet removedFromIndex) {
        return PrimitiveLongCollections.mergeToSet((LongIterable)txState.addedAndRemovedNodes().getRemoved(), (LongIterable)removedFromIndex);
    }

    public void release() {
        if (this.securityNodeCursor != null) {
            this.securityNodeCursor.close();
            this.securityNodeCursor.release();
        }
    }
}

