/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction.log.files.checkpoint;

import java.io.IOException;
import java.nio.channels.ClosedByInterruptException;
import java.nio.file.Path;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.impl.transaction.log.LogEntryCursor;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.kernel.impl.transaction.log.LogVersionBridge;
import org.neo4j.kernel.impl.transaction.log.ReadableClosablePositionAwareChecksumChannel;
import org.neo4j.kernel.impl.transaction.log.ReadableLogChannel;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntry;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryCommit;
import org.neo4j.kernel.impl.transaction.log.entry.LogEntryStart;
import org.neo4j.kernel.impl.transaction.log.entry.LogHeader;
import org.neo4j.kernel.impl.transaction.log.files.LogFile;
import org.neo4j.kernel.impl.transaction.log.files.LogFiles;
import org.neo4j.kernel.impl.transaction.log.files.LogTailInformation;
import org.neo4j.kernel.impl.transaction.log.files.TransactionLogFilesContext;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.AbstractLogTailScanner;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointFile;
import org.neo4j.kernel.impl.transaction.log.files.checkpoint.CheckpointInfo;
import org.neo4j.storageengine.api.StoreId;

public class DetachedLogTailScanner
extends AbstractLogTailScanner {
    private final CheckpointFile checkPointFile;
    private final boolean failOnCorruptedLogFiles;
    private final FileSystemAbstraction fileSystem;

    public DetachedLogTailScanner(LogFiles logFiles, TransactionLogFilesContext context, CheckpointFile checkpointFile) {
        super(logFiles, context.getLogEntryReader(), context.getMonitors(), context.getLogProvider(), context.getMemoryTracker());
        this.checkPointFile = checkpointFile;
        this.fileSystem = context.getFileSystem();
        this.failOnCorruptedLogFiles = context.isFailOnCorruptedLogFiles();
    }

    @Override
    protected LogTailInformation findLogTail() {
        LogFile logFile = this.logFiles.getLogFile();
        long highestLogVersion = logFile.getHighestLogVersion();
        long lowestLogVersion = logFile.getLowestLogVersion();
        try {
            Optional<CheckpointInfo> lastAccessibleCheckpoint = this.checkPointFile.findLatestCheckpoint();
            if (lastAccessibleCheckpoint.isEmpty()) {
                return this.noCheckpointLogTail(logFile, highestLogVersion, lowestLogVersion);
            }
            CheckpointInfo checkpoint = lastAccessibleCheckpoint.get();
            if (this.isValidCheckpoint(logFile, checkpoint)) {
                return this.validCheckpointLogTail(logFile, highestLogVersion, lowestLogVersion, checkpoint);
            }
            if (this.failOnCorruptedLogFiles) {
                String exceptionMessage = String.format("Last available %s checkpoint does not point to a valid location in transaction logs.", checkpoint);
                DetachedLogTailScanner.throwUnableToCleanRecover(new RuntimeException(exceptionMessage));
            }
            List<CheckpointInfo> checkpointInfos = this.checkPointFile.reachableCheckpoints();
            ListIterator<CheckpointInfo> reverseCheckpoints = checkpointInfos.listIterator(checkpointInfos.size() - 1);
            while (reverseCheckpoints.hasPrevious()) {
                CheckpointInfo previousCheckpoint = reverseCheckpoints.previous();
                if (!this.isValidCheckpoint(logFile, previousCheckpoint)) continue;
                return this.validCheckpointLogTail(logFile, highestLogVersion, lowestLogVersion, previousCheckpoint);
            }
            return this.noCheckpointLogTail(logFile, highestLogVersion, lowestLogVersion);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private LogTailInformation validCheckpointLogTail(LogFile logFile, long highestLogVersion, long lowestLogVersion, CheckpointInfo checkpoint) throws IOException {
        StartCommitEntries entries = this.getFirstTransactionIdAfterCheckpoint(logFile, checkpoint.getTransactionLogPosition());
        return new LogTailInformation(checkpoint, entries.isPresent(), entries.getCommitId(), lowestLogVersion == -1L, highestLogVersion, entries.getEntryVersion(), checkpoint.storeId());
    }

    private LogTailInformation noCheckpointLogTail(LogFile logFile, long highestLogVersion, long lowestLogVersion) throws IOException {
        StartCommitEntries entries = this.getFirstTransactionId(logFile, lowestLogVersion);
        return new LogTailInformation(entries.isPresent(), entries.getCommitId(), lowestLogVersion == -1L, highestLogVersion, entries.getEntryVersion());
    }

    private StartCommitEntries getFirstTransactionId(LogFile logFile, long lowestLogVersion) throws IOException {
        LogPosition logPosition = logFile.versionExists(lowestLogVersion) ? logFile.extractHeader(lowestLogVersion).getStartPosition() : new LogPosition(lowestLogVersion, 64L);
        return this.getFirstTransactionIdAfterCheckpoint(logFile, logPosition);
    }

    private boolean isValidCheckpoint(LogFile logFile, CheckpointInfo checkpointInfo) throws IOException {
        LogPosition logPosition = checkpointInfo.getTransactionLogPosition();
        long logVersion = logPosition.getLogVersion();
        if (!logFile.versionExists(logVersion)) {
            return false;
        }
        Path logFileForVersion = logFile.getLogFileForVersion(logVersion);
        if (this.fileSystem.getFileSize(logFileForVersion) < logPosition.getByteOffset()) {
            return false;
        }
        LogHeader logHeader = logFile.extractHeader(logVersion);
        StoreId headerStoreId = logHeader.getStoreId();
        return StoreId.UNKNOWN.equals((Object)headerStoreId) || headerStoreId.equalsIgnoringUpdate((Object)checkpointInfo.storeId());
    }

    private StartCommitEntries getFirstTransactionIdAfterCheckpoint(LogFile logFile, LogPosition logPosition) throws IOException {
        boolean corruptedTransactionLogs = false;
        LogEntryStart start = null;
        LogEntryCommit commit = null;
        LogPosition lookupPosition = null;
        long logVersion = logPosition.getLogVersion();
        try {
            while (logFile.versionExists(logVersion)) {
                lookupPosition = lookupPosition == null ? logPosition : logFile.extractHeader(logVersion).getStartPosition();
                try (ReadableLogChannel reader = logFile.getReader(lookupPosition, LogVersionBridge.NO_MORE_CHANNELS);
                     LogEntryCursor cursor = new LogEntryCursor(this.logEntryReader, (ReadableClosablePositionAwareChecksumChannel)reader);){
                    while ((start == null || commit == null) && cursor.next()) {
                        LogEntry entry = cursor.get();
                        if (commit == null && entry instanceof LogEntryCommit) {
                            commit = (LogEntryCommit)entry;
                            continue;
                        }
                        if (start != null || !(entry instanceof LogEntryStart)) continue;
                        start = (LogEntryStart)entry;
                    }
                }
                if (start != null && commit != null) {
                    return new StartCommitEntries(start, commit);
                }
                this.verifyReaderPosition(logVersion, this.logEntryReader.lastPosition());
                ++logVersion;
            }
        }
        catch (Error | ClosedByInterruptException e) {
            throw e;
        }
        catch (Throwable t) {
            this.monitor.corruptedLogFile(logVersion, t);
            if (this.failOnCorruptedLogFiles) {
                DetachedLogTailScanner.throwUnableToCleanRecover(t);
            }
            corruptedTransactionLogs = true;
        }
        return new StartCommitEntries(start, commit, corruptedTransactionLogs);
    }

    private static class StartCommitEntries {
        private final LogEntryStart start;
        private final LogEntryCommit commit;
        private final boolean corruptedLogs;

        StartCommitEntries(LogEntryStart start, LogEntryCommit commit) {
            this(start, commit, false);
        }

        StartCommitEntries(LogEntryStart start, LogEntryCommit commit, boolean corruptedLogs) {
            this.start = start;
            this.commit = commit;
            this.corruptedLogs = corruptedLogs;
        }

        public long getCommitId() {
            return this.commit != null ? this.commit.getTxId() : -1L;
        }

        public boolean isPresent() {
            return this.start != null || this.commit != null || this.corruptedLogs;
        }

        public byte getEntryVersion() {
            if (this.start != null) {
                return this.start.getVersion();
            }
            if (this.commit != null) {
                return this.commit.getVersion();
            }
            return 0;
        }
    }
}

