/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.monitoring.InternalDatabaseEventListener;
import org.neo4j.kernel.monitoring.PanicDatabaseEvent;
import org.neo4j.kernel.monitoring.StartDatabaseEvent;
import org.neo4j.kernel.monitoring.StopDatabaseEvent;
import org.neo4j.logging.Log;

public class DatabaseEventListeners {
    private final List<DatabaseEventListener> databaseEventListeners = new CopyOnWriteArrayList<DatabaseEventListener>();
    private final List<InternalDatabaseEventListener> internalDatabaseEventListeners = new CopyOnWriteArrayList<InternalDatabaseEventListener>();
    private final Log log;

    public DatabaseEventListeners(Log log) {
        this.log = log;
    }

    public void registerDatabaseEventListener(InternalDatabaseEventListener listener) {
        this.addListener(listener, this.internalDatabaseEventListeners);
    }

    public void unregisterDatabaseEventListener(InternalDatabaseEventListener listener) {
        this.removeListener(listener, this.internalDatabaseEventListeners);
    }

    public void registerDatabaseEventListener(DatabaseEventListener listener) {
        this.addListener(listener, this.databaseEventListeners);
    }

    public void unregisterDatabaseEventListener(DatabaseEventListener listener) {
        this.removeListener(listener, this.databaseEventListeners);
    }

    private <T> void addListener(T listener, List<T> listeners) {
        if (listeners.contains(listener)) {
            return;
        }
        listeners.add(listener);
    }

    private <T> void removeListener(T listener, List<T> listeners) {
        if (!listeners.remove(listener)) {
            throw new IllegalStateException("Database listener `" + listener + "` is not registered.");
        }
    }

    public void databaseStart(NamedDatabaseId databaseId) {
        StartDatabaseEvent event = new StartDatabaseEvent(databaseId);
        this.notifyEventListeners(handler -> handler.databaseStart((DatabaseEventContext)event), this.databaseEventListeners);
        this.notifyEventListeners(handler -> handler.databaseStart(event), this.internalDatabaseEventListeners);
    }

    public void databaseShutdown(NamedDatabaseId databaseId) {
        StopDatabaseEvent event = new StopDatabaseEvent(databaseId);
        this.notifyEventListeners(handler -> handler.databaseShutdown((DatabaseEventContext)event), this.databaseEventListeners);
        this.notifyEventListeners(handler -> handler.databaseShutdown(event), this.internalDatabaseEventListeners);
    }

    void databasePanic(NamedDatabaseId databaseId, Throwable causeOfPanic) {
        PanicDatabaseEvent event = new PanicDatabaseEvent(databaseId, causeOfPanic);
        this.notifyEventListeners(handler -> handler.databasePanic((DatabaseEventContext)event), this.databaseEventListeners);
        this.notifyEventListeners(handler -> handler.databasePanic(event), this.internalDatabaseEventListeners);
    }

    private <T> void notifyEventListeners(Consumer<T> consumer, List<T> listeners) {
        for (T listener : listeners) {
            try {
                consumer.accept(listener);
            }
            catch (Throwable e) {
                this.log.error("Error while handling database event by listener: " + listener, e);
            }
        }
    }
}

