/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.monitoring.tracing;

import java.time.Clock;
import org.apache.commons.lang3.StringUtils;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.transaction.tracing.DatabaseTracer;
import org.neo4j.kernel.monitoring.tracing.DefaultTracerFactory;
import org.neo4j.kernel.monitoring.tracing.NullTracersFactory;
import org.neo4j.kernel.monitoring.tracing.TracerFactory;
import org.neo4j.lock.LockTracer;
import org.neo4j.logging.Log;
import org.neo4j.monitoring.Monitors;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.service.Services;
import org.neo4j.time.SystemNanoClock;

public class Tracers {
    private final PageCacheTracer pageCacheTracer;
    private final TracerFactory tracersFactory;
    private final SystemNanoClock clock;

    public Tracers(String desiredImplementationName, Log msgLog, Monitors monitors, JobScheduler jobScheduler, SystemNanoClock clock) {
        this.clock = clock;
        this.tracersFactory = Tracers.createTracersFactory(desiredImplementationName, msgLog);
        this.pageCacheTracer = this.tracersFactory.createPageCacheTracer(monitors, jobScheduler, clock, msgLog);
    }

    public PageCacheTracer getPageCacheTracer() {
        return this.pageCacheTracer;
    }

    public LockTracer getLockTracer() {
        return this.tracersFactory.createLockTracer((Clock)this.clock);
    }

    public DatabaseTracer getDatabaseTracer() {
        return this.tracersFactory.createDatabaseTracer((Clock)this.clock);
    }

    private static TracerFactory createTracersFactory(String desiredImplementationName, Log msgLog) {
        if ("null".equalsIgnoreCase(desiredImplementationName)) {
            return new NullTracersFactory();
        }
        return Tracers.selectTracerFactory(desiredImplementationName, msgLog);
    }

    private static TracerFactory selectTracerFactory(String desiredImplementationName, Log msgLog) {
        if (StringUtils.isBlank((CharSequence)desiredImplementationName)) {
            return Tracers.createDefaultTracerFactory();
        }
        try {
            return Services.load(TracerFactory.class, (String)desiredImplementationName).orElseGet(() -> {
                msgLog.warn("Using default tracer implementations instead of '%s'", new Object[]{desiredImplementationName});
                return Tracers.createDefaultTracerFactory();
            });
        }
        catch (Exception e) {
            msgLog.warn(String.format("Failed to instantiate desired tracer implementations '%s', using default", desiredImplementationName), (Throwable)e);
            return Tracers.createDefaultTracerFactory();
        }
    }

    private static TracerFactory createDefaultTracerFactory() {
        return new DefaultTracerFactory();
    }
}

