/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.Variables;

public class Session {
    private final Serializable id;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final Map<String, String> aliases = new HashMap<String, String>();

    public Session(Serializable id) {
        this.id = id;
    }

    public Serializable getId() {
        return this.id;
    }

    public void set(String key, Object value) throws ShellException {
        Variables.checkIsValidVariableName(key);
        this.setInternal(key, value);
    }

    private void setInternal(String key, Object value) {
        this.properties.put(key, value);
    }

    public Object get(String key) throws ShellException {
        Variables.checkIsValidVariableName(key);
        return this.getInternal(key);
    }

    private Object getInternal(String key) {
        return this.properties.get(key);
    }

    public boolean has(String key) {
        return this.properties.containsKey(key);
    }

    public Object remove(String key) throws ShellException {
        Variables.checkIsValidVariableName(key);
        return this.properties.remove(key);
    }

    public String[] keys() {
        return this.properties.keySet().toArray(new String[this.properties.size()]);
    }

    public Map<String, Object> asMap() {
        return this.properties;
    }

    public void removeAlias(String key) {
        this.aliases.remove(key);
    }

    public void setAlias(String key, String value) {
        this.aliases.put(key, value);
    }

    public Set<String> getAliasKeys() {
        return this.aliases.keySet();
    }

    public String getAlias(String key) {
        return this.aliases.get(key);
    }

    public void setPath(String path) {
        this.setInternal("WORKING_DIR", path);
    }

    public String getPath() {
        return (String)this.getInternal("WORKING_DIR");
    }

    public void setCurrent(String value) {
        this.setInternal("CURRENT_DIR", value);
    }

    public String getCurrent() {
        return (String)this.getInternal("CURRENT_DIR");
    }

    public Integer getCommitCount() {
        return (Integer)this.getInternal("TX_COUNT");
    }

    public void setCommitCount(int commitCount) {
        this.setInternal("TX_COUNT", commitCount);
    }

    public String getTitleKeys() throws ShellException {
        return (String)this.get("TITLE_KEYS");
    }

    public String getMaxTitleLength() throws ShellException {
        return (String)this.get("TITLE_MAX_LENGTH");
    }
}

