/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Map;
import org.neo4j.shell.Output;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.ShellServer;
import org.neo4j.shell.impl.AbstractClient;
import org.neo4j.shell.impl.RemoteOutput;
import org.neo4j.shell.impl.RmiLocation;

public class RemoteClient
extends AbstractClient {
    private ShellServer server;
    private final RmiLocation serverLocation;
    private final Output out;

    public RemoteClient(Map<String, Serializable> initialSession, RmiLocation serverLocation) throws ShellException {
        this(initialSession, serverLocation, RemoteOutput.newOutput());
    }

    public RemoteClient(Map<String, Serializable> initialSession, RmiLocation serverLocation, Output out) throws ShellException {
        super(initialSession);
        this.serverLocation = serverLocation;
        this.out = out;
        this.server = this.findRemoteServer();
    }

    private ShellServer findRemoteServer() throws ShellException {
        try {
            ShellServer result = (ShellServer)this.serverLocation.getBoundObject();
            this.sayHi(result);
            this.updateTimeForMostRecentConnection();
            return result;
        }
        catch (RemoteException e) {
            throw ShellException.wrapCause(e);
        }
    }

    @Override
    public Output getOutput() {
        return this.out;
    }

    @Override
    public ShellServer getServer() {
        boolean hadServer = this.server != null;
        boolean shouldTryToReconnect = this.server == null;
        try {
            if (!shouldTryToReconnect) {
                this.server.getName();
            }
        }
        catch (RemoteException e) {
            shouldTryToReconnect = true;
        }
        Exception originException = null;
        if (shouldTryToReconnect) {
            this.server = null;
            try {
                this.server = this.findRemoteServer();
                if (hadServer) {
                    this.getOutput().println((Serializable)((Object)"[Reconnected to server]"));
                }
            }
            catch (ShellException ee) {
                originException = ee;
            }
            catch (RemoteException ee) {
                originException = ee;
            }
        }
        if (this.server == null) {
            throw new RuntimeException("Server closed or cannot be reached anymore: " + originException.getMessage(), originException);
        }
        return this.server;
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.tryUnexport(this.out);
    }
}

