/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.rmi.RemoteException;
import java.util.List;
import jline.Completor;
import jline.SimpleCompletor;
import org.neo4j.shell.ShellClient;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.TabCompletion;

class ShellTabCompletor
implements Completor {
    private final ShellClient client;
    private long timeWhenCached;
    private Completor appNameCompletor;

    public ShellTabCompletor(ShellClient client) {
        this.client = client;
    }

    public int complete(String buffer, int cursor, List candidates) {
        if (buffer == null || buffer.length() == 0) {
            return cursor;
        }
        try {
            if (!buffer.contains(" ")) {
                return this.getAppNameCompletor().complete(buffer, cursor, candidates);
            }
            TabCompletion completion = this.client.getServer().tabComplete(this.client.getId(), buffer.trim());
            cursor = completion.getCursor();
            candidates.addAll(completion.getCandidates());
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (ShellException e) {
            e.printStackTrace();
        }
        return cursor;
    }

    private Completor getAppNameCompletor() throws RemoteException {
        if (this.timeWhenCached != this.client.timeForMostRecentConnection()) {
            this.timeWhenCached = this.client.timeForMostRecentConnection();
            this.appNameCompletor = new SimpleCompletor(this.client.getServer().getAllAvailableCommands());
        }
        return this.appNameCompletor;
    }
}

