/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.lang.reflect.Method;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class ScriptEngineViaReflection {
    private static final String JAVAX_SCRIPT_SCRIPT_ENGINE_MANAGER = "javax.script.ScriptEngineManager";
    private static final String JAVAX_SCRIPT_SCRIPT_CONTEXT = "javax.script.ScriptContext";
    private final Object scriptEngineManager;
    private final int engineScopeValue;
    private final GraphDatabaseShellServer server;

    public ScriptEngineViaReflection(GraphDatabaseShellServer server) {
        this.server = server;
        Object scriptEngineManager = null;
        int engineScopeValue = 0;
        try {
            Class<?> scriptEngineManagerClass = Class.forName(JAVAX_SCRIPT_SCRIPT_ENGINE_MANAGER);
            scriptEngineManager = scriptEngineManagerClass.newInstance();
            engineScopeValue = Class.forName(JAVAX_SCRIPT_SCRIPT_CONTEXT).getField("ENGINE_SCOPE").getInt(null);
        }
        catch (Exception e) {
            scriptEngineManager = null;
        }
        this.scriptEngineManager = scriptEngineManager;
        this.engineScopeValue = engineScopeValue;
    }

    public Object getJavascriptEngine() throws Exception {
        return this.getEngineByName("javascript");
    }

    public Object getEngineByName(String name) throws Exception {
        if (this.scriptEngineManager == null) {
            throw new ShellException("Scripting not available, make sure javax.script.* is available on the classpath in the JVM the shell server runs in");
        }
        return this.scriptEngineManager.getClass().getMethod("getEngineByName", String.class).invoke(this.scriptEngineManager, name);
    }

    public Object interpret(Object scriptEngine, String code) throws Exception {
        return scriptEngine.getClass().getMethod("eval", String.class).invoke(scriptEngine, code);
    }

    public void addDefaultContext(Object scriptEngine, Session session, Output out) throws Exception, ShellException {
        this.addToContext(scriptEngine, "db", this.server.getDb(), "out", out, "current", session.getCurrent() == null ? null : TransactionProvidingApp.getCurrent(this.server, session).asPropertyContainer());
    }

    public Object compile(Object scriptEngine, String code) throws Exception {
        return scriptEngine.getClass().getMethod("compile", String.class).invoke(scriptEngine, code);
    }

    public static String decorateWithImports(String code, String ... imports) {
        String importCode = "";
        for (String oneImport : imports) {
            importCode = importCode + ScriptEngineViaReflection.importStatement(oneImport);
        }
        return importCode + code;
    }

    public Object newContext() throws Exception {
        return Class.forName("javax.script.SimpleScriptContext").getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public Object executeCompiledScript(Object compiledScript, Object context) throws Exception {
        Method method = compiledScript.getClass().getMethod("eval", Class.forName(JAVAX_SCRIPT_SCRIPT_CONTEXT));
        method.setAccessible(true);
        return method.invoke(compiledScript, context);
    }

    public void addToContext(Object scriptEngine, Object ... keyValuePairs) throws Exception {
        Object context = scriptEngine.getClass().getMethod("getContext", new Class[0]).invoke(scriptEngine, new Object[0]);
        Method setAttributeMethod = context.getClass().getMethod("setAttribute", String.class, Object.class, Integer.TYPE);
        for (int i = 0; i < keyValuePairs.length; ++i) {
            setAttributeMethod.invoke(context, keyValuePairs[i++], keyValuePairs[i], this.engineScopeValue);
        }
    }

    public void setContextAttribute(Object context, String key, Object value) throws Exception {
        Method setAttributeMethod = context.getClass().getMethod("setAttribute", String.class, Object.class, Integer.TYPE);
        setAttributeMethod.invoke(context, key, value, this.engineScopeValue);
    }

    private static String importStatement(String thePackage) {
        return "importPackage(Packages." + thePackage + ");";
    }
}

