/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.DynamicLabel;
import org.neo4j.graphdb.DynamicRelationshipType;
import org.neo4j.graphdb.Expander;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.NotFoundException;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.PathExpander;
import org.neo4j.graphdb.PropertyContainer;
import org.neo4j.graphdb.Relationship;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.traversal.BranchState;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.OrderedByTypeExpander;
import org.neo4j.kernel.Traversal;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.TextUtil;
import org.neo4j.shell.impl.AbstractApp;
import org.neo4j.shell.kernel.GraphDatabaseShellServer;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.TypedId;
import org.neo4j.shell.util.json.JSONArray;
import org.neo4j.shell.util.json.JSONException;
import org.neo4j.tooling.GlobalGraphOperations;

public abstract class TransactionProvidingApp
extends AbstractApp {
    private static final Label[] EMPTY_LABELS = new Label[0];
    protected static final String[] STANDARD_EVAL_IMPORTS = new String[]{"org.neo4j.graphdb", "org.neo4j.graphdb.event", "org.neo4j.graphdb.index", "org.neo4j.graphdb.traversal", "org.neo4j.kernel"};
    protected static final OptionDefinition OPTION_DEF_FOR_C = new OptionDefinition(OptionValueType.MUST, "Command to run for each returned node. Use $i for node/relationship id, example:\n-c \"ls -f name $i\". Multiple commands can be supplied with && in between");
    private static final PathExpander EMPTY_EXPANDER = new PathExpander(){

        public PathExpander reverse() {
            return this;
        }

        public Iterable<Relationship> expand(Path path, BranchState state) {
            return Collections.emptyList();
        }
    };

    public static NodeOrRelationship getCurrent(GraphDatabaseShellServer server, Session session) throws ShellException {
        String currentThing = session.getCurrent();
        if (currentThing == null || currentThing.equals("(?)")) {
            throw new ShellException("Not currently standing on any entity.");
        }
        TypedId typedId = new TypedId(currentThing);
        NodeOrRelationship result = TransactionProvidingApp.getThingById(server, typedId);
        return result;
    }

    protected NodeOrRelationship getCurrent(Session session) throws ShellException {
        return TransactionProvidingApp.getCurrent(this.getServer(), session);
    }

    public static boolean isCurrent(Session session, NodeOrRelationship thing) throws ShellException {
        String currentThing = session.getCurrent();
        return currentThing != null && currentThing.equals(thing.getTypedId().toString());
    }

    protected static void clearCurrent(Session session) {
        session.setCurrent(TransactionProvidingApp.getDisplayNameForNonExistent());
    }

    protected static void setCurrent(Session session, NodeOrRelationship current) throws ShellException {
        session.setCurrent(current.getTypedId().toString());
    }

    protected void assertCurrentIsNode(Session session) throws ShellException {
        NodeOrRelationship current = this.getCurrent(session);
        if (!current.isNode()) {
            throw new ShellException("You must stand on a node to be able to do this");
        }
    }

    @Override
    public GraphDatabaseShellServer getServer() {
        return (GraphDatabaseShellServer)super.getServer();
    }

    protected static RelationshipType getRelationshipType(String name) {
        return DynamicRelationshipType.withName((String)name);
    }

    protected static Direction getDirection(String direction) throws ShellException {
        return TransactionProvidingApp.getDirection(direction, Direction.OUTGOING);
    }

    protected static Direction getDirection(String direction, Direction defaultDirection) throws ShellException {
        return TransactionProvidingApp.parseEnum(Direction.class, direction, defaultDirection, new Pair[0]);
    }

    protected static NodeOrRelationship getThingById(GraphDatabaseShellServer server, TypedId typedId) throws ShellException {
        NodeOrRelationship result;
        if (typedId.isNode()) {
            try {
                result = NodeOrRelationship.wrap(server.getDb().getNodeById(typedId.getId()));
            }
            catch (NotFoundException e) {
                throw new ShellException("Node " + typedId.getId() + " not found");
            }
        }
        try {
            result = NodeOrRelationship.wrap(server.getDb().getRelationshipById(typedId.getId()));
        }
        catch (NotFoundException e) {
            throw new ShellException("Relationship " + typedId.getId() + " not found");
        }
        return result;
    }

    protected NodeOrRelationship getThingById(TypedId typedId) throws ShellException {
        return TransactionProvidingApp.getThingById(this.getServer(), typedId);
    }

    protected Node getNodeById(long id) {
        return this.getServer().getDb().getNodeById(id);
    }

    @Override
    public Continuation execute(AppCommandParser parser, Session session, Output out) throws Exception {
        try (Transaction tx = this.getServer().getDb().beginTx();){
            Continuation result = this.exec(parser, session, out);
            tx.success();
            Continuation continuation = result;
            return continuation;
        }
    }

    @Override
    public final List<String> completionCandidates(String partOfLine, Session session) throws ShellException {
        try (Transaction tx = this.getServer().getDb().beginTx();){
            List<String> result = this.completionCandidatesInTx(partOfLine, session);
            tx.success();
            List<String> list = result;
            return list;
        }
    }

    protected List<String> completionCandidatesInTx(String partOfLine, Session session) throws ShellException {
        return super.completionCandidates(partOfLine, session);
    }

    protected String directionAlternatives() {
        return "OUTGOING, INCOMING, o, i";
    }

    protected abstract Continuation exec(AppCommandParser var1, Session var2, Output var3) throws Exception;

    protected void printPath(Path path, boolean quietPrint, Session session, Output out) throws RemoteException, ShellException {
        StringBuilder builder = new StringBuilder();
        Node currentNode = null;
        for (PropertyContainer entity : path) {
            String display;
            if (entity instanceof Relationship) {
                display = quietPrint ? "" : TransactionProvidingApp.getDisplayName(this.getServer(), session, (Relationship)entity, false, true);
                display = TransactionProvidingApp.withArrows((Relationship)entity, display, currentNode);
            } else {
                currentNode = (Node)entity;
                display = TransactionProvidingApp.getDisplayName(this.getServer(), session, currentNode, true);
            }
            builder.append(display);
        }
        out.println((Serializable)((Object)builder.toString()));
    }

    protected void setProperties(PropertyContainer entity, String propertyJson) throws ShellException {
        if (propertyJson == null) {
            return;
        }
        try {
            Map<String, Object> properties = TransactionProvidingApp.parseJSONMap(propertyJson);
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                entity.setProperty(entry.getKey(), this.jsonToNeo4jPropertyValue(entry.getValue()));
            }
        }
        catch (JSONException e) {
            throw ShellException.wrapCause(e);
        }
    }

    private Object jsonToNeo4jPropertyValue(Object value) throws ShellException {
        try {
            if (value instanceof JSONArray) {
                JSONArray array = (JSONArray)value;
                Object firstItem = array.get(0);
                Object resultArray = Array.newInstance(firstItem.getClass(), array.length());
                for (int i = 0; i < array.length(); ++i) {
                    Array.set(resultArray, i, array.get(i));
                }
                return resultArray;
            }
            return value;
        }
        catch (JSONException e) {
            throw new ShellException(ShellException.stackTraceAsString(e));
        }
    }

    protected void cdTo(Session session, Node node) throws RemoteException, ShellException {
        List<TypedId> wd = TransactionProvidingApp.readCurrentWorkingDir(session);
        try {
            wd.add(this.getCurrent(session).getTypedId());
        }
        catch (ShellException e) {
            // empty catch block
        }
        TransactionProvidingApp.writeCurrentWorkingDir(wd, session);
        TransactionProvidingApp.setCurrent(session, NodeOrRelationship.wrap(node));
    }

    private static String getDisplayNameForCurrent(GraphDatabaseShellServer server, Session session) throws ShellException {
        NodeOrRelationship current = TransactionProvidingApp.getCurrent(server, session);
        return current.isNode() ? "(me)" : "<me>";
    }

    public static String getDisplayNameForNonExistent() {
        return "(?)";
    }

    public static String getDisplayName(GraphDatabaseShellServer server, Session session, NodeOrRelationship thing, boolean checkForMe) throws ShellException {
        if (thing.isNode()) {
            return TransactionProvidingApp.getDisplayName(server, session, thing.asNode(), checkForMe);
        }
        return TransactionProvidingApp.getDisplayName(server, session, thing.asRelationship(), true, checkForMe);
    }

    public static String getDisplayName(GraphDatabaseShellServer server, Session session, TypedId typedId, boolean checkForMe) throws ShellException {
        return TransactionProvidingApp.getDisplayName(server, session, TransactionProvidingApp.getThingById(server, typedId), checkForMe);
    }

    public static String getDisplayName(GraphDatabaseShellServer server, Session session, Node node, boolean checkForMe) throws ShellException {
        if (checkForMe && TransactionProvidingApp.isCurrent(session, NodeOrRelationship.wrap(node))) {
            return TransactionProvidingApp.getDisplayNameForCurrent(server, session);
        }
        String title = TransactionProvidingApp.findTitle(session, node);
        StringBuilder result = new StringBuilder("(");
        result.append(title != null ? title + "," : "");
        result.append(node.getId());
        result.append(")");
        return result.toString();
    }

    protected static String findTitle(Session session, Node node) throws ShellException {
        String keys = session.getTitleKeys();
        if (keys == null) {
            return null;
        }
        String[] titleKeys = keys.split(Pattern.quote(","));
        Pattern[] patterns = new Pattern[titleKeys.length];
        for (int i = 0; i < titleKeys.length; ++i) {
            patterns[i] = Pattern.compile(titleKeys[i]);
        }
        for (Pattern pattern : patterns) {
            for (String nodeKey : node.getPropertyKeys()) {
                if (!TransactionProvidingApp.matches(pattern, nodeKey, false, false)) continue;
                return TransactionProvidingApp.trimLength(session, TransactionProvidingApp.format(node.getProperty(nodeKey), false));
            }
        }
        return null;
    }

    private static String trimLength(Session session, String string) throws ShellException {
        int maxLength;
        String maxLengthString = session.getMaxTitleLength();
        int n = maxLength = maxLengthString != null ? Integer.parseInt(maxLengthString) : Integer.MAX_VALUE;
        if (string.length() > maxLength) {
            string = string.substring(0, maxLength) + "...";
        }
        return string;
    }

    public static String getDisplayName(GraphDatabaseShellServer server, Session session, Relationship relationship, boolean verbose, boolean checkForMe) throws ShellException {
        if (checkForMe && TransactionProvidingApp.isCurrent(session, NodeOrRelationship.wrap(relationship))) {
            return TransactionProvidingApp.getDisplayNameForCurrent(server, session);
        }
        StringBuilder result = new StringBuilder("[");
        result.append(":").append(relationship.getType().name());
        result.append(verbose ? "," + relationship.getId() : "");
        result.append("]");
        return result.toString();
    }

    public static String withArrows(Relationship relationship, String displayName, Node leftNode) {
        if (relationship.getStartNode().equals(leftNode)) {
            return "-" + displayName + "->";
        }
        if (relationship.getEndNode().equals(leftNode)) {
            return "<-" + displayName + "-";
        }
        throw new IllegalArgumentException(leftNode + " is neither start nor end node to " + relationship);
    }

    protected static String fixCaseSensitivity(String string, boolean caseInsensitive) {
        return caseInsensitive ? string.toLowerCase() : string;
    }

    protected static Pattern newPattern(String pattern, boolean caseInsensitive) {
        return pattern == null ? null : Pattern.compile(TransactionProvidingApp.fixCaseSensitivity(pattern, caseInsensitive));
    }

    protected static boolean matches(Pattern patternOrNull, String value, boolean caseInsensitive, boolean loose) {
        if (patternOrNull == null) {
            return true;
        }
        value = TransactionProvidingApp.fixCaseSensitivity(value, caseInsensitive);
        return loose ? patternOrNull.matcher(value).find() : patternOrNull.matcher(value).matches();
    }

    protected static <T extends Enum<T>> String niceEnumAlternatives(Class<T> enumClass) {
        StringBuilder builder = new StringBuilder("[");
        int count = 0;
        for (Enum enumConstant : (Enum[])enumClass.getEnumConstants()) {
            builder.append(count++ == 0 ? "" : ", ");
            builder.append(enumConstant.name());
        }
        return builder.append("]").toString();
    }

    protected static <T extends Enum<T>> T parseEnum(Class<T> enumClass, String name, T defaultValue, Pair<String, T> ... additionalPairs) {
        if (name == null) {
            return defaultValue;
        }
        name = name.toLowerCase();
        for (Enum enum_ : (Enum[])enumClass.getEnumConstants()) {
            if (!enum_.name().equalsIgnoreCase(name)) continue;
            return (T)enum_;
        }
        for (Enum enum_ : (Enum[])enumClass.getEnumConstants()) {
            if (!enum_.name().toLowerCase().startsWith(name)) continue;
            return (T)enum_;
        }
        for (Enum enum_ : additionalPairs) {
            if (!((String)enum_.first()).equalsIgnoreCase(name)) continue;
            return (T)((Enum)enum_.other());
        }
        for (Enum enum_ : additionalPairs) {
            if (!((String)enum_.first()).toLowerCase().startsWith(name)) continue;
            return (T)((Enum)enum_.other());
        }
        throw new IllegalArgumentException("No '" + name + "' or '" + name + ".*' in " + enumClass);
    }

    protected static boolean filterMatches(Map<String, Object> filterMap, boolean caseInsensitiveFilters, boolean looseFilters, String key, Object value) {
        if (filterMap == null || filterMap.isEmpty()) {
            return true;
        }
        for (Map.Entry<String, Object> filter : filterMap.entrySet()) {
            String filterValue;
            if (!TransactionProvidingApp.matches(TransactionProvidingApp.newPattern(filter.getKey(), caseInsensitiveFilters), key, caseInsensitiveFilters, looseFilters) || !TransactionProvidingApp.matches(TransactionProvidingApp.newPattern(filterValue = filter.getValue() != null ? filter.getValue().toString() : null, caseInsensitiveFilters), value.toString(), caseInsensitiveFilters, looseFilters)) continue;
            return true;
        }
        return false;
    }

    protected static String frame(String string, boolean frame) {
        return frame ? "[" + string + "]" : string;
    }

    protected static String format(Object value, boolean includeFraming) {
        String result;
        if (value.getClass().isArray()) {
            StringBuilder buffer = new StringBuilder();
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                Object singleValue = Array.get(value, i);
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(TransactionProvidingApp.frame(singleValue.toString(), includeFraming));
            }
            result = buffer.toString();
        } else {
            result = TransactionProvidingApp.frame(value.toString(), includeFraming);
        }
        return result;
    }

    protected static void printAndInterpretTemplateLines(Collection<String> templateLines, boolean forcePrintHitHeader, boolean newLineBetweenHits, NodeOrRelationship entity, GraphDatabaseShellServer server, Session session, Output out) throws ShellException, RemoteException {
        if (templateLines.isEmpty() || forcePrintHitHeader) {
            out.println((Serializable)((Object)TransactionProvidingApp.getDisplayName(server, session, entity, true)));
        }
        if (!templateLines.isEmpty()) {
            HashMap<String, Long> data = new HashMap<String, Long>();
            data.put("i", entity.getId());
            for (String command : templateLines) {
                String line = TextUtil.templateString(command, data);
                server.interpretLine(session.getId(), line, out);
            }
        }
        if (newLineBetweenHits) {
            out.println();
        }
    }

    public static List<TypedId> readCurrentWorkingDir(Session session) throws RemoteException {
        ArrayList<TypedId> list = new ArrayList<TypedId>();
        String path = session.getPath();
        if (path != null && path.trim().length() > 0) {
            for (String typedId : path.split(",")) {
                list.add(new TypedId(typedId));
            }
        }
        return list;
    }

    public static void writeCurrentWorkingDir(List<TypedId> paths, Session session) throws RemoteException {
        String path = TransactionProvidingApp.makePath(paths);
        session.setPath(path);
    }

    private static String makePath(List<TypedId> paths) {
        StringBuilder buffer = new StringBuilder();
        for (TypedId typedId : paths) {
            if (buffer.length() > 0) {
                buffer.append(",");
            }
            buffer.append(typedId.toString());
        }
        return buffer.length() > 0 ? buffer.toString() : null;
    }

    protected static Map<String, Direction> filterMapToTypes(GraphDatabaseService db, Direction defaultDirection, Map<String, Object> filterMap, boolean caseInsensitiveFilters, boolean looseFilters) throws ShellException {
        TreeMap<String, Direction> matches = new TreeMap<String, Direction>();
        for (RelationshipType type : GlobalGraphOperations.at((GraphDatabaseService)db).getAllRelationshipTypes()) {
            Direction direction = null;
            if (filterMap == null || filterMap.isEmpty()) {
                direction = defaultDirection;
            } else {
                for (Map.Entry<String, Object> entry : filterMap.entrySet()) {
                    if (!TransactionProvidingApp.matches(TransactionProvidingApp.newPattern(entry.getKey(), caseInsensitiveFilters), type.name(), caseInsensitiveFilters, looseFilters)) continue;
                    direction = TransactionProvidingApp.getDirection(entry.getValue() != null ? entry.getValue().toString() : null, defaultDirection);
                    break;
                }
            }
            if (direction == null) continue;
            matches.put(type.name(), direction);
        }
        return matches.isEmpty() ? Collections.emptyMap() : matches;
    }

    protected static PathExpander toExpander(GraphDatabaseService db, Direction defaultDirection, Map<String, Object> relationshipTypes, boolean caseInsensitiveFilters, boolean looseFilters) throws ShellException {
        defaultDirection = defaultDirection != null ? defaultDirection : Direction.BOTH;
        Map<String, Direction> matches = TransactionProvidingApp.filterMapToTypes(db, defaultDirection, relationshipTypes, caseInsensitiveFilters, looseFilters);
        Expander expander = Traversal.emptyExpander();
        if (matches == null) {
            return EMPTY_EXPANDER;
        }
        for (Map.Entry<String, Direction> entry : matches.entrySet()) {
            expander = expander.add((RelationshipType)DynamicRelationshipType.withName((String)entry.getKey()), entry.getValue());
        }
        return (PathExpander)expander;
    }

    protected static PathExpander toSortedExpander(GraphDatabaseService db, Direction defaultDirection, Map<String, Object> relationshipTypes, boolean caseInsensitiveFilters, boolean looseFilters) throws ShellException {
        defaultDirection = defaultDirection != null ? defaultDirection : Direction.BOTH;
        Map<String, Direction> matches = TransactionProvidingApp.filterMapToTypes(db, defaultDirection, relationshipTypes, caseInsensitiveFilters, looseFilters);
        OrderedByTypeExpander expander = new OrderedByTypeExpander();
        for (Map.Entry<String, Direction> entry : matches.entrySet()) {
            expander = expander.add((RelationshipType)DynamicRelationshipType.withName((String)entry.getKey()), entry.getValue());
        }
        return (PathExpander)expander;
    }

    protected Label[] parseLabels(AppCommandParser parser) {
        String labelValue = parser.option("l", null);
        if (labelValue == null) {
            return EMPTY_LABELS;
        }
        if ((labelValue = labelValue.trim()).startsWith("[")) {
            Object[] items = TransactionProvidingApp.parseArray(labelValue);
            Label[] labels = new Label[items.length];
            for (int i = 0; i < items.length; ++i) {
                labels[i] = this.labelWithOrWithoutColon(items[i].toString());
            }
            return labels;
        }
        return new Label[]{this.labelWithOrWithoutColon(labelValue)};
    }

    private Label labelWithOrWithoutColon(String label) {
        String labelName = label.startsWith(":") ? label.substring(1) : label;
        return DynamicLabel.label((String)labelName);
    }
}

