/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.traversal.BranchOrderingPolicy;
import org.neo4j.graphdb.traversal.Evaluation;
import org.neo4j.graphdb.traversal.Evaluator;
import org.neo4j.graphdb.traversal.Evaluators;
import org.neo4j.graphdb.traversal.TraversalDescription;
import org.neo4j.graphdb.traversal.UniquenessFactory;
import org.neo4j.helpers.Pair;
import org.neo4j.kernel.CommonBranchOrdering;
import org.neo4j.kernel.Traversal;
import org.neo4j.kernel.Uniqueness;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.NodeOrRelationship;
import org.neo4j.shell.kernel.apps.ScriptEngineViaReflection;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class Trav
extends TransactionProvidingApp {
    private ScriptEngineViaReflection scripting;

    public Trav() {
        this.addOptionDefinition("o", new OptionDefinition(OptionValueType.MUST, "The traversal order [BREADTH_FIRST/DEPTH_FIRST/breadth/depth]"));
        this.addOptionDefinition("r", new OptionDefinition(OptionValueType.MUST, "The relationship type(s) expressed as a JSON string (supports regex matching of the types) f.ex. \"MY_REL_TYPE:out,.*_HAS_.*:both\". Matching is case-insensitive."));
        this.addOptionDefinition("f", new OptionDefinition(OptionValueType.MUST, "Filters node property keys/values. Supplied either as a single value or as a JSON string where both keys and values can contain regex. Starting/ending {} brackets are optional. Examples:\n\"username\"\n   nodes which has property 'username' gets listed\n\".*name: ma.*, age: ''\"\n   nodes which has any key matching '.*name' where the property value\n   for that key matches 'ma.*' AND has the 'age' property gets listed"));
        this.addOptionDefinition("i", new OptionDefinition(OptionValueType.NONE, "Filters are case-insensitive (case-sensitive by default)"));
        this.addOptionDefinition("l", new OptionDefinition(OptionValueType.NONE, "Filters matches more loosely, i.e. it's considered a match if just a part of a value matches the pattern, not necessarily the whole value"));
        this.addOptionDefinition("c", OPTION_DEF_FOR_C);
        this.addOptionDefinition("d", new OptionDefinition(OptionValueType.MUST, "Depth limit"));
        this.addOptionDefinition("e", new OptionDefinition(OptionValueType.MUST, "Custom javascript evaluator"));
        this.addOptionDefinition("u", new OptionDefinition(OptionValueType.MUST, "Uniqueness of the entities encountered during traversal " + Trav.niceEnumAlternatives(Uniqueness.class)));
    }

    @Override
    public String getDescription() {
        return "Traverses the graph from your current position (pwd). It's a reflection of the neo4j traverser API with some options for filtering which nodes will be returned.";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws ShellException, RemoteException {
        String filterString;
        String evaluator;
        String depthLimit;
        String uniqueness;
        String relationshipTypes;
        this.assertCurrentIsNode(session);
        Node node = this.getCurrent(session).asNode();
        boolean caseInsensitiveFilters = parser.options().containsKey("i");
        boolean looseFilters = parser.options().containsKey("l");
        boolean quiet = parser.options().containsKey("q");
        TraversalDescription description = Traversal.description();
        String order = parser.options().get("o");
        if (order != null) {
            description = description.order(this.parseOrder(order));
        }
        if ((relationshipTypes = parser.options().get("r")) != null) {
            Map<String, Object> types = Trav.parseFilter(relationshipTypes, out);
            description = description.expand(Trav.toExpander((GraphDatabaseService)this.getServer().getDb(), null, types, caseInsensitiveFilters, looseFilters));
        }
        if ((uniqueness = parser.options().get("u")) != null) {
            description = description.uniqueness(this.parseUniqueness(uniqueness));
        }
        if ((depthLimit = parser.options().get("d")) != null) {
            description = description.evaluator(Evaluators.toDepth((int)Integer.parseInt(depthLimit)));
        }
        if ((evaluator = parser.options().get("e")) != null) {
            description = description.evaluator(this.parseEvaluator(evaluator));
        }
        Map<String, Object> filterMap = (filterString = parser.options().get("f")) != null ? Trav.parseFilter(filterString, out) : null;
        String commandToRun = parser.options().get("c");
        ArrayList<String> commandsToRun = new ArrayList<String>();
        if (commandToRun != null) {
            commandsToRun.addAll(Arrays.asList(commandToRun.split(Pattern.quote("&&"))));
        }
        for (Path path : description.traverse(node)) {
            boolean hit = false;
            if (filterMap == null) {
                hit = true;
            } else {
                Node endNode = path.endNode();
                HashMap<String, Boolean> matchPerFilterKey = new HashMap<String, Boolean>();
                for (String key : endNode.getPropertyKeys()) {
                    for (Map.Entry<String, Object> filterEntry : filterMap.entrySet()) {
                        String filterKey = filterEntry.getKey();
                        if (matchPerFilterKey.containsKey(filterKey) || !Trav.matches(Trav.newPattern(filterKey, caseInsensitiveFilters), key, caseInsensitiveFilters, looseFilters)) continue;
                        Object value = endNode.getProperty(key);
                        String filterPattern = filterEntry.getValue() != null ? filterEntry.getValue().toString() : null;
                        if (!Trav.matches(Trav.newPattern(filterPattern, caseInsensitiveFilters), value.toString(), caseInsensitiveFilters, looseFilters)) continue;
                        matchPerFilterKey.put(filterKey, true);
                    }
                }
                if (matchPerFilterKey.size() == filterMap.size()) {
                    hit = true;
                }
            }
            if (!hit) continue;
            if (commandsToRun.isEmpty()) {
                this.printPath(path, quiet, session, out);
                continue;
            }
            Trav.printAndInterpretTemplateLines(commandsToRun, false, true, NodeOrRelationship.wrap(path.endNode()), this.getServer(), session, out);
        }
        return Continuation.INPUT_COMPLETE;
    }

    private Evaluator parseEvaluator(String evaluator) throws ShellException {
        this.scripting = this.scripting != null ? this.scripting : new ScriptEngineViaReflection(this.getServer());
        try {
            evaluator = ScriptEngineViaReflection.decorateWithImports(evaluator, STANDARD_EVAL_IMPORTS);
            Object scriptEngine = this.scripting.getJavascriptEngine();
            Object compiledScript = this.scripting.compile(scriptEngine, evaluator);
            return new CompiledScriptEvaluator(compiledScript);
        }
        catch (Exception e) {
            throw ShellException.wrapCause(e);
        }
    }

    private UniquenessFactory parseUniqueness(String uniqueness) {
        return Trav.parseEnum(Uniqueness.class, uniqueness, null, new Pair[0]);
    }

    private BranchOrderingPolicy parseOrder(String order) {
        if (order.equals("depth first") || "depth first".startsWith(order.toLowerCase())) {
            return Traversal.preorderDepthFirst();
        }
        if (order.equals("breadth first") || "breadth first".startsWith(order.toLowerCase())) {
            return Traversal.preorderBreadthFirst();
        }
        return Trav.parseEnum(CommonBranchOrdering.class, order, null, new Pair[0]);
    }

    private class CompiledScriptEvaluator
    implements Evaluator {
        private final Object compiledScript;
        private final Object context;

        CompiledScriptEvaluator(Object compiledScript) throws Exception {
            this.compiledScript = compiledScript;
            this.context = Trav.this.scripting.newContext();
        }

        public Evaluation evaluate(Path path) {
            try {
                Trav.this.scripting.setContextAttribute(this.context, "position", path);
                Object result = Trav.this.scripting.executeCompiledScript(this.compiledScript, this.context);
                if (result instanceof Boolean) {
                    return Evaluation.ofIncludes((boolean)((Boolean)result));
                }
                if (result instanceof Evaluation) {
                    return (Evaluation)result;
                }
                throw new IllegalArgumentException("Cannot return value " + result + " from an evaluator");
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }
}

