/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.kernel.apps;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.concurrent.TimeUnit;
import org.neo4j.function.Function;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;
import org.neo4j.graphdb.schema.Schema;
import org.neo4j.helpers.Predicate;
import org.neo4j.helpers.collection.Iterables;
import org.neo4j.kernel.api.Statement;
import org.neo4j.kernel.api.index.IndexDescriptor;
import org.neo4j.kernel.impl.api.index.IndexingService;
import org.neo4j.kernel.impl.api.index.sampling.IndexSamplingMode;
import org.neo4j.shell.AppCommandParser;
import org.neo4j.shell.ColumnPrinter;
import org.neo4j.shell.Continuation;
import org.neo4j.shell.OptionDefinition;
import org.neo4j.shell.OptionValueType;
import org.neo4j.shell.Output;
import org.neo4j.shell.Session;
import org.neo4j.shell.ShellException;
import org.neo4j.shell.kernel.apps.TransactionProvidingApp;

public class Schema
extends TransactionProvidingApp {
    private static final Function<IndexDefinition, String> LABEL_COMPARE_FUNCTION = new Function<IndexDefinition, String>(){

        public String apply(IndexDefinition index) {
            return index.getLabel().name();
        }
    };

    public Schema() {
        this.addOptionDefinition("l", new OptionDefinition(OptionValueType.MUST, "Specifies which label selected operation is about"));
        this.addOptionDefinition("p", new OptionDefinition(OptionValueType.MUST, "Specifies which property selected operation is about"));
        this.addOptionDefinition("a", new OptionDefinition(OptionValueType.NONE, "Used together with schema sample to indicate that all indexes should be sampled"));
        this.addOptionDefinition("f", new OptionDefinition(OptionValueType.NONE, "Used together with schema sample to force indexes to be sampled"));
        this.addOptionDefinition("v", new OptionDefinition(OptionValueType.NONE, "Verbose output of failure descriptions etc."));
    }

    @Override
    public String getDescription() {
        return "Accesses db schema. Usage: schema <action> <options...>\nListing indexes\n  schema ls\n  schema ls -l :Person\nSample indexes all indexes\n  schema sample -a\nSample a specific index\n  schema sample -l :Person -p name\nForce a sampling of a specific index\n  schema sample -f -l :Person -p name\nAwaiting indexes to come online\n  schema await -l Person -p name";
    }

    @Override
    protected Continuation exec(AppCommandParser parser, Session session, Output out) throws Exception {
        String action = parser.argumentWithDefault(0, "ls");
        org.neo4j.graphdb.schema.Schema schema = this.getServer().getDb().schema();
        Label[] labels = this.parseLabels(parser);
        String property = parser.option("p", null);
        boolean sampleAll = parser.options().containsKey("a");
        boolean forceSample = parser.options().containsKey("f");
        boolean verbose = parser.options().containsKey("v");
        if (action.equals("await")) {
            this.awaitIndexes(out, schema, labels, property);
        } else if (action.equals("ls")) {
            this.listIndexesAndConstraints(out, schema, labels, property, verbose);
        } else if (action.equals("sample")) {
            this.sampleIndexes(labels, property, sampleAll, forceSample);
        } else {
            out.println((Serializable)((Object)("Unknown action: " + action + "\nUSAGE:\n" + this.getDescription())));
        }
        return Continuation.INPUT_COMPLETE;
    }

    private void sampleIndexes(Label[] labels, String property, boolean sampleAll, boolean forceSample) throws ShellException {
        IndexingService indexingService = (IndexingService)this.getServer().getDb().getDependencyResolver().resolveDependency(IndexingService.class);
        if (indexingService == null) {
            throw new ShellException("Internal error: failed to resolve IndexingService");
        }
        IndexSamplingMode samplingMode = this.getSamplingMode(forceSample);
        if (sampleAll) {
            indexingService.triggerIndexSampling(samplingMode);
            return;
        }
        this.validateLabelsAndProperty(labels, property);
        Statement statement = this.getServer().getStatement();
        int labelKey = statement.readOperations().labelGetForName(labels[0].name());
        int propertyKey = statement.readOperations().propertyKeyGetForName(property);
        if (labelKey == -1) {
            throw new ShellException("No label associated with '" + labels[0].name() + "' was found");
        }
        if (propertyKey == -1) {
            throw new ShellException("No property associated with '" + property + "' was found");
        }
        indexingService.triggerIndexSampling(new IndexDescriptor(labelKey, propertyKey), samplingMode);
    }

    private IndexSamplingMode getSamplingMode(boolean forceSample) {
        if (forceSample) {
            return IndexSamplingMode.TRIGGER_REBUILD_ALL;
        }
        return IndexSamplingMode.TRIGGER_REBUILD_UPDATED;
    }

    private void validateLabelsAndProperty(Label[] labels, String property) throws ShellException {
        if (labels.length == 0 && property == null) {
            throw new ShellException("Invalid usage of sample. \nUSAGE:\n" + this.getDescription());
        }
        if (labels.length > 1) {
            throw new ShellException("Only one label must be provided");
        }
        if (property == null || labels.length == 0) {
            throw new ShellException("Provide both the property and the label, or run with -a to sample all indexes");
        }
    }

    private void awaitIndexes(Output out, org.neo4j.graphdb.schema.Schema schema, Label[] labels, String property) throws RemoteException {
        for (IndexDefinition index : this.indexesByLabelAndProperty(schema, labels, property)) {
            if (schema.getIndexState(index) == Schema.IndexState.ONLINE) continue;
            out.println((Serializable)((Object)String.format("Awaiting :%s ON %s %s", index.getLabel().name(), Iterables.toList((Iterable)index.getPropertyKeys()), Schema.IndexState.ONLINE)));
            schema.awaitIndexOnline(index, 10000L, TimeUnit.DAYS);
        }
    }

    private void listIndexesAndConstraints(Output out, org.neo4j.graphdb.schema.Schema schema, Label[] labels, String property, boolean verbose) throws RemoteException {
        this.reportIndexes(out, schema, labels, property, verbose);
        this.reportConstraints(out, schema, labels, property);
    }

    private void reportConstraints(Output out, org.neo4j.graphdb.schema.Schema schema, Label[] labels, String property) throws RemoteException {
        int j = 0;
        for (ConstraintDefinition constraint : this.constraintsByLabelAndProperty(schema, labels, property)) {
            if (j == 0) {
                out.println();
                out.println((Serializable)((Object)"Constraints"));
            }
            String labelName = constraint.getLabel().name();
            out.println((Serializable)((Object)String.format("  ON (%s:%s) ASSERT %s", labelName.toLowerCase(), labelName, constraint.toString())));
            ++j;
        }
        if (j == 0) {
            out.println();
            out.println((Serializable)((Object)"No constraints"));
        }
    }

    private void reportIndexes(Output out, org.neo4j.graphdb.schema.Schema schema, Label[] labels, String property, boolean verbose) throws RemoteException {
        ColumnPrinter printer = new ColumnPrinter("  ON ", "", "");
        Iterable<IndexDefinition> indexes = this.indexesByLabelAndProperty(schema, labels, property);
        int i = 0;
        for (IndexDefinition index : Iterables.sort(indexes, LABEL_COMPARE_FUNCTION)) {
            if (i == 0) {
                out.println((Serializable)((Object)"Indexes"));
            }
            String labelAndProperties = String.format(":%s(%s)", index.getLabel().name(), this.commaSeparate(index.getPropertyKeys()));
            Schema.IndexState state = schema.getIndexState(index);
            String uniqueOrNot = index.isConstraintIndex() ? "(for uniqueness constraint)" : "";
            printer.add(labelAndProperties, state, uniqueOrNot);
            if (verbose && state == Schema.IndexState.FAILED) {
                printer.addRaw(schema.getIndexFailure(index));
            }
            ++i;
        }
        if (i == 0) {
            out.println((Serializable)((Object)"No indexes"));
        } else {
            printer.print(out);
        }
    }

    private String commaSeparate(Iterable<String> keys) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (String key : keys) {
            if (!first) {
                builder.append(", ");
            } else {
                first = false;
            }
            builder.append(key);
        }
        return builder.toString();
    }

    private Iterable<IndexDefinition> indexesByLabelAndProperty(org.neo4j.graphdb.schema.Schema schema, Label[] labels, final String property) {
        Iterable indexes = this.indexesByLabel(schema, labels);
        if (property != null) {
            indexes = Iterables.filter((Predicate)new Predicate<IndexDefinition>(){

                public boolean accept(IndexDefinition index) {
                    return Iterables.indexOf((Object)property, (Iterable)index.getPropertyKeys()) != -1;
                }
            }, indexes);
        }
        return indexes;
    }

    private Iterable<ConstraintDefinition> constraintsByLabelAndProperty(org.neo4j.graphdb.schema.Schema schema, final Label[] labels, final String property) {
        return Iterables.filter((Predicate)new Predicate<ConstraintDefinition>(){

            public boolean accept(ConstraintDefinition constraint) {
                return Schema.this.hasLabel(constraint, labels) && Schema.this.isMatchingConstraint(constraint, property);
            }
        }, (Iterable)schema.getConstraints());
    }

    private boolean hasLabel(ConstraintDefinition constraint, Label[] labels) {
        if (labels.length == 0) {
            return true;
        }
        for (Label label : labels) {
            if (!constraint.getLabel().name().equals(label.name())) continue;
            return true;
        }
        return false;
    }

    private boolean isMatchingConstraint(ConstraintDefinition constraint, String property) {
        if (property == null) {
            return true;
        }
        return Iterables.indexOf((Object)property, (Iterable)constraint.getPropertyKeys()) != -1;
    }

    private Iterable<IndexDefinition> indexesByLabel(org.neo4j.graphdb.schema.Schema schema, Label[] labels) {
        Iterable indexes = schema.getIndexes();
        for (final Label label : labels) {
            indexes = Iterables.filter((Predicate)new Predicate<IndexDefinition>(){

                public boolean accept(IndexDefinition item) {
                    return item.getLabel().name().equals(label.name());
                }
            }, (Iterable)indexes);
        }
        return indexes;
    }
}

