/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.impl;

import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Map;
import org.neo4j.shell.impl.HostBoundSocketFactory;

public class RmiLocation {
    private String host;
    private int port;
    private String name;

    private RmiLocation() {
    }

    private RmiLocation(String host, int port, String name) {
        this.host = host;
        this.port = port;
        this.name = name;
    }

    public static RmiLocation location(String url) {
        int protocolIndex = url.indexOf("://");
        int portIndex = url.lastIndexOf(58);
        int nameIndex = url.indexOf("/", portIndex);
        String host = url.substring(protocolIndex + 3, portIndex);
        int port = Integer.parseInt(url.substring(portIndex + 1, nameIndex));
        String name = url.substring(nameIndex + 1);
        return RmiLocation.location(host, port, name);
    }

    public static RmiLocation location(String host, int port, String name) {
        return new RmiLocation(host, port, name);
    }

    public static RmiLocation location(Map<String, Object> data) {
        String host = (String)data.get("host");
        Integer port = (Integer)data.get("port");
        String name = (String)data.get("name");
        return RmiLocation.location(host, port, name);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getName() {
        return this.name;
    }

    private static String getProtocol() {
        return "rmi://";
    }

    public String toShortUrl() {
        return RmiLocation.getProtocol() + this.getHost() + ":" + this.getPort();
    }

    public String toUrl() {
        return RmiLocation.getProtocol() + this.getHost() + ":" + this.getPort() + "/" + this.getName();
    }

    public boolean hasRegistry() {
        try {
            Naming.list(this.toShortUrl());
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public Registry ensureRegistryCreated() throws RemoteException {
        try {
            Naming.list(this.toShortUrl());
            return LocateRegistry.getRegistry(this.getHost(), this.getPort());
        }
        catch (RemoteException e) {
            try {
                return LocateRegistry.createRegistry(this.getPort(), null, new HostBoundSocketFactory(this.host));
            }
            catch (UnknownHostException hostException) {
                throw new RemoteException("Unable to bind to '" + this.host + "', unknown hostname.", hostException);
            }
        }
        catch (MalformedURLException e) {
            throw new RemoteException("Malformed URL", e);
        }
    }

    public void bind(Remote object) throws RemoteException {
        this.ensureRegistryCreated();
        try {
            Naming.rebind(this.toUrl(), object);
        }
        catch (MalformedURLException e) {
            throw new RemoteException("Malformed URL", e);
        }
    }

    public void unbind(Remote object) throws RemoteException {
        try {
            Naming.unbind(this.toUrl());
            UnicastRemoteObject.unexportObject(object, true);
        }
        catch (NotBoundException e) {
            throw new RemoteException("Not bound", e);
        }
        catch (MalformedURLException e) {
            throw new RemoteException("Malformed URL", e);
        }
    }

    public boolean isBound() {
        try {
            this.getBoundObject();
            return true;
        }
        catch (RemoteException e) {
            return false;
        }
    }

    public Remote getBoundObject() throws RemoteException {
        try {
            return Naming.lookup(this.toUrl());
        }
        catch (NotBoundException e) {
            throw new RemoteException("Not bound", e);
        }
        catch (MalformedURLException e) {
            throw new RemoteException("Malformed URL", e);
        }
    }
}

