/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.concurrent;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.ReentrantLock;

public class KeyLock<K> {
    private ConcurrentMap<K, ReentrantLock> locks;
    private final boolean fair;

    public KeyLock() {
        this(false);
    }

    public KeyLock(boolean fair) {
        this.fair = fair;
        this.locks = new ConcurrentHashMap<K, ReentrantLock>();
    }

    public void lock(K key) {
        ReentrantLock zlock = (ReentrantLock)this.locks.get(key);
        if (zlock != null && zlock.isHeldByCurrentThread()) {
            zlock.lock();
            return;
        }
        ReentrantLock mlock = new ReentrantLock(this.fair);
        mlock.lock();
        ReentrantLock olock = this.locks.putIfAbsent(key, mlock);
        while (olock != null) {
            ReentrantLock plock = olock;
            plock.lock();
            olock = this.locks.putIfAbsent(key, mlock);
            plock.unlock();
        }
    }

    public void unlock(K key) {
        ReentrantLock clock = (ReentrantLock)this.locks.get(key);
        if (clock == null) {
            throw new IllegalMonitorStateException("Actually doesn't exists any lock for key " + key);
        }
        clock.unlock();
        if (clock.getHoldCount() == 0) {
            this.locks.remove(key);
        }
    }
}

