/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.converter;

import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.nerd4j.converter.BeanConverter;
import org.nerd4j.util.EmptyIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CollectionConverterIterator<S, T>
implements Iterator<T> {
    private static final Logger logger = LoggerFactory.getLogger(CollectionConverterIterator.class);
    private final BeanConverter<S, ? extends Collection<T>> converter;
    private final Iterator<S> iterator;
    private final boolean ignoreFailures;
    private Iterator<T> next = EmptyIterator.intance();

    public CollectionConverterIterator(BeanConverter<S, ? extends Collection<T>> converter, Iterator<S> iterator) {
        this(converter, iterator, false);
    }

    public CollectionConverterIterator(BeanConverter<S, ? extends Collection<T>> converter, Iterator<S> iterator, boolean ignoreFailures) {
        this.converter = converter;
        this.iterator = iterator;
        this.ignoreFailures = ignoreFailures;
    }

    @Override
    public boolean hasNext() {
        this.prepareNextIfNeeded();
        return this.next.hasNext();
    }

    @Override
    public T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements");
        }
        return this.next.next();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operation not nupported");
    }

    private void prepareNextIfNeeded() {
        while (!this.next.hasNext() && this.iterator.hasNext()) {
            S source = this.iterator.next();
            try {
                this.next = this.converter.convert(source).iterator();
            }
            catch (Exception e) {
                if (this.ignoreFailures) {
                    logger.warn("Got a uncovertible bean {} due to {}. Skipping it.", source, (Object)e.getMessage());
                    continue;
                }
                throw new IllegalArgumentException("Got a uncovertible bean " + source, e);
            }
        }
    }
}

