/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.format;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.nerd4j.format.Formatted;
import org.nerd4j.util.ReflectionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormattedClassHandler {
    private static final Logger logger = LoggerFactory.getLogger(FormattedClassHandler.class);
    private static final FormattedClassHandler instance = new FormattedClassHandler();
    private static final String NULL_OBJECT_STRING = "<null>";
    private static final String UNREACH_OBJECT_STRING = "<undef>";
    private static final String SEEN_OBJECT_STRING = "<seen>";
    private final Map<Class<?>, List<FormattedConfiguration>> configurationCache = new ConcurrentHashMap();
    private static final ThreadLocal<ExecutionMemory> executions = new ThreadLocal();

    public static FormattedClassHandler getInstance() {
        return instance;
    }

    private FormattedClassHandler() {
    }

    public String toStringContent(Object object) {
        return this.toStringContent(object, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String toStringContent(Object object, boolean printNull) {
        ExecutionMemory execution = executions.get();
        if (execution == null) {
            execution = new ExecutionMemory(object);
            executions.set(execution);
        }
        if (!execution.seen.add(object)) {
            return SEEN_OBJECT_STRING;
        }
        StringBuilder builder = new StringBuilder();
        try {
            Class<?> objectClass = object.getClass();
            List<FormattedConfiguration> configurations = this.configurationCache.get(objectClass);
            if (configurations == null) {
                configurations = this.createFormattedConfigurations(objectClass);
                this.configurationCache.put(objectClass, configurations);
            } else {
                logger.debug("Found a cached configuration for class {}.", (Object)objectClass.getSimpleName());
            }
            for (FormattedConfiguration configuration : configurations) {
                Object objectToPrint = null;
                try {
                    objectToPrint = this.getInstanceToPrint(object, configuration);
                }
                catch (NullPointerException ex) {
                    objectToPrint = objectToPrint == null && printNull ? UNREACH_OBJECT_STRING : objectToPrint;
                }
                if ((objectToPrint = objectToPrint == null && printNull ? NULL_OBJECT_STRING : objectToPrint) == null) continue;
                if (builder.length() != 0) {
                    builder.append(configuration.tokenSeparator);
                }
                builder.append(configuration.key);
                builder.append(configuration.valueSeparator);
                builder.append(objectToPrint);
            }
        }
        catch (Exception e) {
            logger.error("Unexpected Exception while evaluating toStringContent for class {}.", object.getClass(), (Object)e);
        }
        finally {
            if (execution.root == object) {
                execution.seen.clear();
                executions.remove();
            }
        }
        return builder.toString();
    }

    private List<ReflectionObject> createInvocationList(String[] properties, ReflectionObject reflectionObject, Class<?> clazz, Formatted annotation) {
        List<ReflectionObject> invokes = new ArrayList<ReflectionObject>(properties.length + 1);
        invokes.add(reflectionObject);
        Class<?> lookupClazz = reflectionObject.getType();
        for (String property : properties) {
            Method method = null;
            try {
                method = lookupClazz.isInterface() ? ReflectionUtil.findPublicGetter(property, lookupClazz) : ReflectionUtil.findGetter(property, lookupClazz);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (method == null) {
                if (logger.isErrorEnabled()) {
                    logger.error("Cannot found a getter method for property '{}' on {} {}. Annotation {} from class {} will be skipped.", new Object[]{property, lookupClazz.isInterface() ? "interface " : "class ", lookupClazz.getSimpleName(), annotation.toString(), clazz.getCanonicalName()});
                }
                invokes = Collections.emptyList();
                break;
            }
            int modifier = method.getModifiers();
            if (!Modifier.isPublic(modifier)) {
                logger.warn("Accessing a non public method; consider to change method access or remove @Formatted {} from class {}.", (Object)annotation.toString(), (Object)clazz.getCanonicalName());
            }
            invokes.add(new ReflectionMethod(method));
            lookupClazz = method.getReturnType();
        }
        return invokes;
    }

    private FormattedConfiguration createFormattedConfiguration(Class<?> clazz, Method method, Formatted annotation) {
        logger.trace("Generating a new Formatted configuration for method {}.", (Object)method.getName());
        if (ReflectionUtil.isGetter(method)) {
            return this.createFormattedConfiguration(clazz, new ReflectionMethod(method), annotation);
        }
        logger.warn("Annotated method {} isn't a getter. Annotation {} from class {} will be skipped.", new Object[]{method.getName(), annotation, clazz});
        return null;
    }

    private FormattedConfiguration createFormattedConfiguration(Class<?> clazz, Field field, Formatted annotation) {
        logger.trace("Generating a new Formatted configuration for field {}.", (Object)field.getName());
        return this.createFormattedConfiguration(clazz, new ReflectionField(field), annotation);
    }

    private FormattedConfiguration createFormattedConfiguration(Class<?> clazz, ReflectionObject reflective, Formatted annotation) {
        String propertyPath = annotation.value();
        String[] propertyTokens = propertyPath.isEmpty() ? new String[]{} : propertyPath.split(Pattern.quote("."));
        List<ReflectionObject> invokes = this.createInvocationList(propertyTokens, reflective, clazz, annotation);
        if (!invokes.isEmpty()) {
            FormattedConfiguration configuration = new FormattedConfiguration();
            configuration.key = annotation.key().isEmpty() ? reflective.getPropertyName() : annotation.key();
            configuration.tokenSeparator = annotation.tokenSeparator();
            configuration.valueSeparator = annotation.valueSeparator();
            configuration.invokes = invokes;
            logger.debug("Generated a new Formatted configuration for annotation {} from class {}.", (Object)annotation, (Object)clazz.getCanonicalName());
            logger.trace("Generated Formatted configuration: {}.", (Object)configuration);
            return configuration;
        }
        return null;
    }

    private List<FormattedConfiguration> createFormattedConfigurations(Class<?> clazz) {
        logger.trace("Generating a new Formatted configuration for class {}.", (Object)clazz.getSimpleName());
        ArrayList<FormattedConfiguration> result = new ArrayList<FormattedConfiguration>();
        Map<Field, Formatted> fields = ReflectionUtil.findAnnotatedFields(Formatted.class, clazz);
        for (Map.Entry<Field, Formatted> field : fields.entrySet()) {
            FormattedConfiguration configuration = this.createFormattedConfiguration(clazz, field.getKey(), field.getValue());
            if (configuration == null) continue;
            result.add(configuration);
        }
        Map<Method, Formatted> methods = ReflectionUtil.findAnnotatedMethods(Formatted.class, clazz);
        for (Map.Entry<Method, Formatted> method : methods.entrySet()) {
            FormattedConfiguration configuration = this.createFormattedConfiguration(clazz, method.getKey(), method.getValue());
            if (configuration == null) continue;
            result.add(configuration);
        }
        logger.debug("Generated a new Formatted configuration for class {}; configuration size: {}.", (Object)clazz.getSimpleName(), (Object)result.size());
        return result;
    }

    private Object getInstanceToPrint(Object object, FormattedConfiguration configuration) {
        Object objectToPrint = object;
        for (ReflectionObject reflective : configuration.invokes) {
            boolean isPublic = Modifier.isPublic(reflective.getModifiers() & reflective.getDeclaringClass().getModifiers());
            boolean notAccessible = !isPublic && !reflective.isAccessible();
            try {
                if (notAccessible) {
                    logger.warn("Backing {} wasn't accessible; changing accessibility status.", (Object)reflective);
                    reflective.setAccessible(true);
                }
                objectToPrint = reflective.getValue(objectToPrint);
            }
            catch (IllegalAccessException ex) {
                logger.error("Cannot access {}.", (Object)reflective, (Object)ex);
                return null;
            }
            catch (IllegalArgumentException ex) {
                logger.error("Unexpected exception.", (Throwable)ex);
                return null;
            }
            catch (InvocationTargetException ex) {
                logger.error("Unexpected exception.", (Throwable)ex);
                return null;
            }
        }
        return objectToPrint;
    }

    private class ReflectionField
    implements ReflectionObject {
        private final Field field;

        public ReflectionField(Field field) {
            this.field = field;
        }

        @Override
        public int getModifiers() {
            return this.field.getModifiers();
        }

        @Override
        public boolean isAccessible() {
            return this.field.isAccessible();
        }

        @Override
        public void setAccessible(boolean flag) {
            this.field.setAccessible(flag);
        }

        @Override
        public String getPropertyName() {
            return this.field.getName();
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public Object getValue(Object instance) throws IllegalArgumentException, IllegalAccessException {
            return this.field.get(instance);
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.field.getDeclaringClass();
        }

        public String toString() {
            return ReflectionField.class.getSimpleName() + "[field=" + this.field + "]";
        }
    }

    private class ReflectionMethod
    implements ReflectionObject {
        private final Method method;

        public ReflectionMethod(Method method) {
            this.method = method;
        }

        @Override
        public int getModifiers() {
            return this.method.getModifiers();
        }

        @Override
        public boolean isAccessible() {
            return this.method.isAccessible();
        }

        @Override
        public String getPropertyName() {
            return ReflectionUtil.propertyFromGetter(this.method);
        }

        @Override
        public void setAccessible(boolean flag) {
            this.method.setAccessible(flag);
        }

        @Override
        public Class<?> getType() {
            return this.method.getReturnType();
        }

        @Override
        public Object getValue(Object instance) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            return this.method.invoke(instance, (Object[])null);
        }

        @Override
        public Class<?> getDeclaringClass() {
            return this.method.getDeclaringClass();
        }

        public String toString() {
            return ReflectionMethod.class.getSimpleName() + "[method=" + this.method + "]";
        }
    }

    private static interface ReflectionObject {
        public int getModifiers();

        public boolean isAccessible();

        public void setAccessible(boolean var1) throws SecurityException;

        public String getPropertyName();

        public Class<?> getType();

        public Object getValue(Object var1) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException;

        public Class<?> getDeclaringClass();
    }

    private static class FormattedConfiguration {
        private String key;
        private String tokenSeparator;
        private String valueSeparator;
        private List<ReflectionObject> invokes;

        private FormattedConfiguration() {
        }

        public String toString() {
            return FormattedConfiguration.class.getSimpleName() + "[key=" + this.key + ", tokenSeparator=" + this.tokenSeparator + ", valueSeparator=" + this.valueSeparator + ", invokes=" + this.invokes + "]";
        }
    }

    private static final class ExecutionMemory {
        public Object root;
        public Set<Object> seen;

        public ExecutionMemory(Object root) {
            this.root = root;
            this.seen = new HashSet<Object>(1);
        }
    }
}

