/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.lang;

import org.nerd4j.format.AnnotatedFormattedBean;
import org.nerd4j.format.Formatted;
import org.nerd4j.lang.Interval;
import org.nerd4j.util.HashCoder;

public abstract class AbstractInterval<T>
extends AnnotatedFormattedBean
implements Interval<T> {
    private static final long serialVersionUID = 1L;
    @Formatted
    protected T begin;
    @Formatted
    protected T end;

    protected AbstractInterval(T begin, T end) {
        if (begin == null || end == null) {
            throw new NullPointerException("Both begin and end must not be null");
        }
        if (!this.isLessThan(begin, end)) {
            throw new IllegalArgumentException("Interval begin value must be less than its end");
        }
        this.begin = begin;
        this.end = end;
    }

    @Override
    public T getBegin() {
        return this.begin;
    }

    @Override
    public T getEnd() {
        return this.end;
    }

    @Override
    public boolean overlaps(Interval<T> interval) {
        return this.isInRange(interval.getBegin()) || interval.isInRange(this.getBegin());
    }

    @Override
    public boolean includes(Interval<T> interval) {
        T begin = interval.getBegin();
        T end = interval.getEnd();
        return this.isInRange(begin) && (end.equals(this.getEnd()) || this.isInRange(end));
    }

    public static <X> boolean isInRange(X value, Interval<X> interval) {
        return interval.isInRange(value);
    }

    public static <X> boolean overlaps(Interval<X> i1, Interval<X> i2) {
        return i1.overlaps(i2);
    }

    public static <X> boolean includes(Interval<X> i1, Interval<X> i2) {
        return i1.includes(i2);
    }

    protected abstract boolean isLessThan(T var1, T var2);

    public int hashCode() {
        return HashCoder.hashCode(this.getBegin().hashCode(), this.getEnd().hashCode());
    }

    public boolean equals(Object object) {
        if (object instanceof Interval) {
            Interval other = (Interval)object;
            return this.getBegin().equals(other.getBegin()) && this.getEnd().equals(other.getEnd());
        }
        return false;
    }
}

