/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.lang;

import java.util.LinkedHashMap;
import java.util.Map;

public class SpoolingLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_MAX_ENTRIES = 128;
    private final int maximumCapacity;

    public SpoolingLinkedHashMap(int maximumCapacity, int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.maximumCapacity = initialCapacity < maximumCapacity ? maximumCapacity : initialCapacity;
    }

    public SpoolingLinkedHashMap(int maximumCapacity, int initialCapacity) {
        super(initialCapacity);
        this.maximumCapacity = initialCapacity < maximumCapacity ? maximumCapacity : initialCapacity;
    }

    public SpoolingLinkedHashMap(int maximumCapacity) {
        this.maximumCapacity = maximumCapacity;
    }

    public SpoolingLinkedHashMap() {
        this.maximumCapacity = 128;
    }

    public SpoolingLinkedHashMap(int maximumCapacity, Map<? extends K, ? extends V> m) {
        super(m);
        this.maximumCapacity = m.size() < maximumCapacity ? maximumCapacity : m.size();
    }

    public SpoolingLinkedHashMap(int maximumCapacity, int initialCapacity, float loadFactor, boolean accessOrder) {
        super(initialCapacity, loadFactor, accessOrder);
        this.maximumCapacity = initialCapacity < maximumCapacity ? maximumCapacity : initialCapacity;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return this.size() > this.maximumCapacity;
    }
}

