/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.lang.bitfield;

import java.io.Serializable;
import java.util.Arrays;
import org.nerd4j.lang.BitField;

public abstract class AbstractBitField<I>
implements BitField<I>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final int size;
    private byte[] data;

    public AbstractBitField(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("You must provide a size greater than 0.");
        }
        this.size = size;
        int length = this.lengthFromSize(size);
        this.data = new byte[length];
    }

    public AbstractBitField(byte[] data) {
        if (data == null || data.length < 1) {
            throw new IllegalArgumentException("You must provide a not empty byte array.");
        }
        this.size = this.sizeFromLength(data.length);
        this.data = Arrays.copyOf(data, data.length);
    }

    public AbstractBitField(int size, byte[] data) {
        if (data == null || data.length < 1) {
            throw new IllegalArgumentException("You must provide a not empty byte array.");
        }
        if (size < 1) {
            throw new IllegalArgumentException("You must provide a size greater than 0.");
        }
        if (!this.checkCapacity(data, size)) {
            throw new IllegalArgumentException("The provided size exceeds the byte array capacity.");
        }
        this.size = size;
        int length = this.lengthFromSize(size);
        this.data = Arrays.copyOf(data, length);
    }

    protected abstract int evaluateIndex(I var1) throws NullPointerException;

    private boolean checkCapacity(byte[] data, int size) {
        return data.length * 8 > size;
    }

    private int lengthFromSize(int size) {
        return (size - 1) / 8 + 1;
    }

    private int sizeFromLength(int length) {
        return length * 8;
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range [0," + this.size + ").");
        }
    }

    private boolean boolAtPosition(byte data, int position) {
        return (data >> position & 1) != 0;
    }

    private boolean getBitAtIndex(int index) {
        this.checkIndex(index);
        int block = index / 8;
        int position = index % 8;
        if (block >= this.data.length) {
            return false;
        }
        return this.boolAtPosition(this.data[block], position);
    }

    private boolean setBitAtIndex(int index, boolean value) {
        this.checkIndex(index);
        int block = index / 8;
        int position = index % 8;
        byte mask = (byte)(1 << position);
        boolean old = this.boolAtPosition(this.data[block], position);
        if (value) {
            int n = block;
            this.data[n] = (byte)(this.data[n] | mask);
        } else {
            int n = block;
            this.data[n] = (byte)(this.data[n] & ~mask);
        }
        return old;
    }

    private boolean toggleBitAtIndex(int index) {
        this.checkIndex(index);
        int block = index / 8;
        int position = index % 8;
        byte mask = (byte)(1 << position);
        int n = block;
        this.data[n] = (byte)(this.data[n] ^ mask);
        return this.boolAtPosition(this.data[block], position);
    }

    @Override
    public boolean get(I index) {
        return this.getBitAtIndex(this.evaluateIndex(index));
    }

    @Override
    public boolean set(I index, boolean value) {
        return this.setBitAtIndex(this.evaluateIndex(index), value);
    }

    @Override
    public boolean toggle(I index) {
        return this.toggleBitAtIndex(this.evaluateIndex(index));
    }

    @Override
    public int size() {
        return this.size;
    }

    public AbstractBitField<I> clone() {
        try {
            AbstractBitField clone = (AbstractBitField)super.clone();
            clone.data = Arrays.copyOf(this.data, this.data.length);
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public byte[] toByteArray() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractBitField other = (AbstractBitField)obj;
        return Arrays.equals(this.data, other.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.size + 30);
        sb.append(this.getClass().getSimpleName()).append("[size=").append(this.size).append(",data=");
        if (this.data.length > 1) {
            for (int i = 0; i < this.data.length - 1; ++i) {
                this.printByte(this.data[i], 8, sb);
                sb.append("-");
            }
        }
        this.printByte(this.data[this.data.length - 1], this.size % 8, sb);
        sb.append("]");
        return sb.toString();
    }

    private void printByte(byte b, int size, StringBuilder sb) {
        for (int k = 0; k < size; ++k) {
            sb.append(b >>> k & 1);
        }
    }
}

