/*
 * Decompiled with CFR 0.152.
 */
package org.nerd4j.lang.bitfield;

import java.io.Serializable;
import org.nerd4j.lang.BitField;

public abstract class AbstractTinyBitField<I>
implements BitField<I>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    private final int size;
    private long data;

    public AbstractTinyBitField() {
        this(64, 0L);
    }

    public AbstractTinyBitField(int size) {
        this(size, 0L);
    }

    public AbstractTinyBitField(int size, long data) {
        if (size < 1) {
            throw new IllegalArgumentException("You must provide a size greater than 0.");
        }
        if (size > 64) {
            throw new IllegalArgumentException("You must provide a size lesser than 64.");
        }
        this.size = size;
        this.data = data & -1L >>> 64 - size;
    }

    protected abstract int evaluateIndex(I var1) throws NullPointerException;

    private void checkIndex(int index) {
        if (index < 0 || index >= this.size) {
            throw new IndexOutOfBoundsException("Index " + index + " out of range [0," + this.size + ").");
        }
    }

    private boolean getBitAtIndex(int index) {
        this.checkIndex(index);
        return (this.data >> index & 1L) != 0L;
    }

    private boolean setBitAtIndex(int index, boolean value) {
        this.checkIndex(index);
        long mask = 1 << index;
        boolean old = this.getBitAtIndex(index);
        this.data = value ? (this.data |= mask) : (this.data &= mask ^ 0xFFFFFFFFFFFFFFFFL);
        return old;
    }

    private boolean toggleBitAtIndex(int index) {
        this.checkIndex(index);
        long mask = 1 << index;
        this.data ^= mask;
        return this.getBitAtIndex(index);
    }

    @Override
    public boolean get(I index) {
        return this.getBitAtIndex(this.evaluateIndex(index));
    }

    @Override
    public boolean set(I index, boolean value) {
        return this.setBitAtIndex(this.evaluateIndex(index), value);
    }

    @Override
    public boolean toggle(I index) {
        return this.toggleBitAtIndex(this.evaluateIndex(index));
    }

    @Override
    public int size() {
        return this.size;
    }

    public AbstractTinyBitField<I> clone() {
        try {
            AbstractTinyBitField clone = (AbstractTinyBitField)super.clone();
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError(e.toString());
        }
    }

    public byte[] toByteArray() {
        byte[] result = new byte[]{(byte)(this.data & 0xFFL), (byte)(this.data >> 8 & 0xFFL), (byte)(this.data >> 16 & 0xFFL), (byte)(this.data >> 24 & 0xFFL), (byte)(this.data >> 32 & 0xFFL), (byte)(this.data >> 40 & 0xFFL), (byte)(this.data >> 48 & 0xFFL), (byte)(this.data >> 56 & 0xFFL)};
        return result;
    }

    public long toLong() {
        return this.data;
    }

    public int hashCode() {
        return (int)(this.data ^ this.data >>> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractTinyBitField other = (AbstractTinyBitField)obj;
        return this.data == other.data;
    }

    public String toString() {
        int lastSize;
        StringBuilder sb = new StringBuilder(this.size + 30);
        sb.append(this.getClass().getSimpleName()).append("[size=").append(this.size).append(",data=");
        int blocks = (this.size - 1) / 8 + 1;
        if (blocks > 1) {
            for (int i = 0; i < blocks - 1; ++i) {
                this.printByte((byte)(this.data >> i * 8 & 0xFFL), 8, sb);
                sb.append("-");
            }
        }
        lastSize = (lastSize = this.size % 8) == 0 ? 8 : lastSize;
        this.printByte((byte)(this.data >> (blocks - 1) * 8 & 0xFFL), lastSize, sb);
        sb.append("]");
        return sb.toString();
    }

    private void printByte(byte b, int size, StringBuilder sb) {
        for (int k = 0; k < size; ++k) {
            sb.append(b >>> k & 1);
        }
    }
}

